/*
 * Decompiled with CFR 0.152.
 */
package com.takoy3466.ManaitaMTK.block.blockEntity;

import com.takoy3466.ManaitaMTK.MTKEnum;
import com.takoy3466.ManaitaMTK.regi.ManaitaMTKBlocks;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MTKFurnaceBlockEntityBase
extends BaseContainerBlockEntity
implements WorldlyContainer,
RecipeHolder,
StackedContentsCompatible {
    private static final int[] SLOTS_FOR_UP = new int[]{0};
    private static final int[] SLOTS_FOR_DOWN = new int[]{2, 1};
    private static final int[] SLOTS_FOR_SIDES = new int[]{1};
    private final RecipeType<? extends AbstractCookingRecipe> recipeType;
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed;
    private final RecipeManager.CachedCheck<Container, ? extends AbstractCookingRecipe> quickCheck;
    private LazyOptional<? extends IItemHandler>[] handlers;
    private NonNullList<ItemStack> items;
    private int litTime;
    private int litDuration;
    private int cookingProgress;
    private int cookingTotalTime;
    public final ContainerData dataAccess;
    private final MTKEnum mtkEnum;
    private final Component guiName = Component.m_237115_((String)"block.manaitamtk.mtk_furnace.title");

    public MTKFurnaceBlockEntityBase(BlockPos pos, BlockState state, MTKEnum mtkEnum) {
        super(switch (mtkEnum) {
            case MTKEnum.WOOD -> (BlockEntityType)ManaitaMTKBlocks.BlockEntities.MTK_FURNACE_WOOD.get();
            case MTKEnum.STONE -> (BlockEntityType)ManaitaMTKBlocks.BlockEntities.MTK_FURNACE_STONE.get();
            case MTKEnum.IRON -> (BlockEntityType)ManaitaMTKBlocks.BlockEntities.MTK_FURNACE_IRON.get();
            case MTKEnum.GOLD -> (BlockEntityType)ManaitaMTKBlocks.BlockEntities.MTK_FURNACE_GOLD.get();
            case MTKEnum.DIAMOND -> (BlockEntityType)ManaitaMTKBlocks.BlockEntities.MTK_FURNACE_DIAMOND.get();
            case MTKEnum.MTK -> (BlockEntityType)ManaitaMTKBlocks.BlockEntities.MTK_FURNACE_MTK.get();
            case MTKEnum.GODMTK -> (BlockEntityType)ManaitaMTKBlocks.BlockEntities.MTK_FURNACE_GODMTK.get();
            case MTKEnum.BREAK -> (BlockEntityType)ManaitaMTKBlocks.BlockEntities.MTK_FURNACE_BREAK.get();
            default -> null;
        }, pos, state);
        this.mtkEnum = mtkEnum;
        this.items = NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_);
        this.recipeType = RecipeType.f_44108_;
        this.recipesUsed = new Object2IntOpenHashMap();
        this.handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});
        this.quickCheck = RecipeManager.m_220267_((RecipeType)RecipeType.f_44108_);
        this.dataAccess = new ContainerData(){

            public int m_6413_(int i) {
                return switch (i) {
                    case 0 -> MTKFurnaceBlockEntityBase.this.litTime;
                    case 1 -> MTKFurnaceBlockEntityBase.this.litDuration;
                    case 2 -> MTKFurnaceBlockEntityBase.this.cookingProgress;
                    case 3 -> MTKFurnaceBlockEntityBase.this.cookingTotalTime;
                    default -> 0;
                };
            }

            public void m_8050_(int i, int i1) {
                switch (i) {
                    case 0: {
                        MTKFurnaceBlockEntityBase.this.litTime = i1;
                        break;
                    }
                    case 1: {
                        MTKFurnaceBlockEntityBase.this.litDuration = i1;
                        break;
                    }
                    case 2: {
                        MTKFurnaceBlockEntityBase.this.cookingProgress = i1;
                        break;
                    }
                    case 3: {
                        MTKFurnaceBlockEntityBase.this.cookingTotalTime = i1;
                    }
                }
            }

            public int m_6499_() {
                return 4;
            }
        };
    }

    protected Component m_6820_() {
        return Component.m_237113_((String)(this.guiName.getString() + " x" + this.mtkEnum.getMag()));
    }

    public AbstractContainerMenu m_6555_(int id, Inventory inventory) {
        return null;
    }

    private static int getTotalCookTime() {
        return 1;
    }

    private boolean burn(RegistryAccess access, @javax.annotation.Nullable Recipe<Container> recipe, NonNullList<ItemStack> stacks, int i) {
        if (recipe != null && this.canBurn(access, recipe, stacks, i)) {
            ItemStack input = (ItemStack)stacks.get(0);
            ItemStack result = recipe.m_5874_((Container)this, access);
            result.m_41764_(result.m_41613_() * this.mtkEnum.getMag());
            ItemStack output = (ItemStack)stacks.get(2);
            if (output.m_41619_()) {
                stacks.set(2, (Object)result.m_41777_());
            } else if (output.m_150930_(result.m_41720_())) {
                output.m_41769_(result.m_41613_());
            }
            if (input.m_150930_(Blocks.f_50057_.m_5456_()) && !((ItemStack)stacks.get(1)).m_41619_() && ((ItemStack)stacks.get(1)).m_150930_(Items.f_42446_)) {
                stacks.set(1, (Object)new ItemStack((ItemLike)Items.f_42447_));
            }
            input.m_41774_(1);
            return true;
        }
        return false;
    }

    private boolean isLit() {
        return this.litTime > 0;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        this.litTime = tag.m_128451_("BurnTime");
        this.cookingProgress = tag.m_128451_("CookTime");
        this.cookingTotalTime = tag.m_128451_("CookTimeTotal");
        this.litDuration = this.getBurnDuration((ItemStack)this.items.get(1));
        CompoundTag compoundtag = tag.m_128469_("RecipesUsed");
        for (String s : compoundtag.m_128431_()) {
            this.recipesUsed.put((Object)new ResourceLocation(s), compoundtag.m_128451_(s));
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("BurnTime", this.litTime);
        tag.m_128405_("CookTime", this.cookingProgress);
        tag.m_128405_("CookTimeTotal", this.cookingTotalTime);
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
        CompoundTag compoundtag = new CompoundTag();
        this.recipesUsed.forEach((resourceLocation, integer) -> compoundtag.m_128405_(resourceLocation.toString(), integer.intValue()));
        tag.m_128365_("RecipesUsed", (Tag)compoundtag);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, @NotNull MTKFurnaceBlockEntityBase blockEntity) {
        boolean flag3;
        boolean flag = blockEntity.isLit();
        boolean flag1 = false;
        if (blockEntity.isLit()) {
            --blockEntity.litTime;
        }
        ItemStack itemstack = (ItemStack)blockEntity.items.get(1);
        boolean flag2 = !((ItemStack)blockEntity.items.get(0)).m_41619_();
        boolean bl = flag3 = !itemstack.m_41619_();
        if (!(blockEntity.isLit() || flag3 && flag2)) {
            if (!blockEntity.isLit() && blockEntity.cookingProgress > 0) {
                blockEntity.cookingProgress = Mth.m_14045_((int)(blockEntity.cookingProgress - 2), (int)0, (int)blockEntity.cookingTotalTime);
            }
        } else {
            Recipe recipe = flag2 ? (Recipe)blockEntity.quickCheck.m_213657_((Container)blockEntity, level).orElse(null) : null;
            int i = blockEntity.m_6893_();
            if (!blockEntity.isLit() && blockEntity.canBurn(level.m_9598_(), (Recipe<Container>)recipe, blockEntity.items, i)) {
                blockEntity.litDuration = blockEntity.litTime = blockEntity.getBurnDuration(itemstack);
                if (blockEntity.isLit()) {
                    flag1 = true;
                    if (itemstack.hasCraftingRemainingItem()) {
                        blockEntity.items.set(1, (Object)itemstack.getCraftingRemainingItem());
                    } else if (flag3) {
                        itemstack.m_41774_(1);
                        if (itemstack.m_41619_()) {
                            blockEntity.items.set(1, (Object)itemstack.getCraftingRemainingItem());
                        }
                    }
                }
            }
            if (blockEntity.isLit() && blockEntity.canBurn(level.m_9598_(), (Recipe<Container>)recipe, blockEntity.items, i)) {
                ++blockEntity.cookingProgress;
                if (blockEntity.cookingProgress == blockEntity.cookingTotalTime) {
                    blockEntity.cookingProgress = 0;
                    blockEntity.cookingTotalTime = MTKFurnaceBlockEntityBase.getTotalCookTime();
                    if (blockEntity.burn(level.m_9598_(), (Recipe<Container>)recipe, blockEntity.items, i)) {
                        blockEntity.m_6029_(recipe);
                    }
                    flag1 = true;
                }
            } else {
                blockEntity.cookingProgress = 0;
            }
        }
        if (flag != blockEntity.isLit()) {
            flag1 = true;
            state = (BlockState)state.m_61124_((Property)AbstractFurnaceBlock.f_48684_, (Comparable)Boolean.valueOf(blockEntity.isLit()));
            level.m_7731_(pos, state, 3);
        }
        if (flag1) {
            MTKFurnaceBlockEntityBase.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    private boolean canBurn(RegistryAccess access, @javax.annotation.Nullable Recipe<Container> recipe, NonNullList<ItemStack> stacks, int i) {
        if (!((ItemStack)stacks.get(0)).m_41619_() && recipe != null) {
            ItemStack stack = recipe.m_5874_((Container)this, access);
            if (stack.m_41619_()) {
                return false;
            }
            ItemStack stack1 = (ItemStack)stacks.get(2);
            if (stack1.m_41619_()) {
                return true;
            }
            if (!ItemStack.m_41656_((ItemStack)stack1, (ItemStack)stack)) {
                return false;
            }
            if (stack1.m_41613_() + stack.m_41613_() <= i && stack1.m_41613_() + stack.m_41613_() <= stack1.m_41741_()) {
                return true;
            }
            return stack1.m_41613_() + stack.m_41613_() <= stack.m_41741_();
        }
        return false;
    }

    private int getBurnDuration(ItemStack stack) {
        if (stack.m_41619_()) {
            return 0;
        }
        return ForgeHooks.getBurnTime((ItemStack)stack, this.recipeType);
    }

    public boolean m_7013_(int i, ItemStack stack) {
        if (i == 2) {
            return false;
        }
        if (i != 1) {
            return true;
        }
        ItemStack itemstack = (ItemStack)this.items.get(1);
        return ForgeHooks.getBurnTime((ItemStack)stack, this.recipeType) > 0 || stack.m_150930_(Items.f_42446_) && !itemstack.m_150930_(Items.f_42446_);
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        ItemStack itemstack;
        Iterator var1 = this.items.iterator();
        do {
            if (var1.hasNext()) continue;
            return true;
        } while ((itemstack = (ItemStack)var1.next()).m_41619_());
        return false;
    }

    public ItemStack m_8020_(int i) {
        return (ItemStack)this.items.get(i);
    }

    public ItemStack m_7407_(int i, int i1) {
        return ContainerHelper.m_18969_(this.items, (int)i, (int)i1);
    }

    public ItemStack m_8016_(int i) {
        return ContainerHelper.m_18966_(this.items, (int)i);
    }

    public void m_6836_(int i, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.items.get(i);
        boolean flag = !stack.m_41619_() && ItemStack.m_150942_((ItemStack)itemstack, (ItemStack)stack);
        this.items.set(i, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        if (i == 0 && !flag) {
            this.cookingTotalTime = MTKFurnaceBlockEntityBase.getTotalCookTime();
            this.cookingProgress = 0;
            this.m_6596_();
        }
    }

    public boolean m_6542_(Player player) {
        return Container.m_272074_((BlockEntity)this, (Player)player);
    }

    public void m_6211_() {
        this.items.clear();
    }

    public int[] m_7071_(Direction direction) {
        if (direction == Direction.DOWN) {
            return SLOTS_FOR_DOWN;
        }
        return direction == Direction.UP ? SLOTS_FOR_UP : SLOTS_FOR_SIDES;
    }

    public boolean m_7155_(int i, ItemStack stack, @javax.annotation.Nullable Direction direction) {
        return this.m_7013_(i, stack);
    }

    public boolean m_7157_(int i, ItemStack stack, Direction direction) {
        if (direction == Direction.DOWN && i == 1) {
            return stack.m_150930_(Items.f_42447_) || stack.m_150930_(Items.f_42446_);
        }
        return true;
    }

    public void m_6029_(@Nullable Recipe<?> recipe) {
        if (recipe != null) {
            ResourceLocation resourcelocation = recipe.m_6423_();
            this.recipesUsed.addTo((Object)resourcelocation, 1);
        }
    }

    @Nullable
    public Recipe<?> m_7928_() {
        return null;
    }

    public void m_5809_(StackedContents stackedContents) {
        for (ItemStack itemstack : this.items) {
            stackedContents.m_36491_(itemstack);
        }
    }

    public void m_58395_(Player p_281647_, List<ItemStack> list) {
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @javax.annotation.Nullable Direction facing) {
        if (capability == ForgeCapabilities.ITEM_HANDLER && facing != null && !this.f_58859_) {
            return switch (facing) {
                case Direction.UP -> this.handlers[0].cast();
                case Direction.DOWN -> this.handlers[1].cast();
                default -> this.handlers[2].cast();
            };
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        for (int x = 0; x < this.handlers.length; ++x) {
            this.handlers[x].invalidate();
        }
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});
    }
}

