/*
 * Decompiled with CFR 0.152.
 */
package com.takoy3466.manaitamtk.item.tool;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.takoy3466.manaitamtk.KeyMapping.MTKKeyMapping;
import com.takoy3466.manaitamtk.init.ManaitaMTKItems;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MTKSwitcherScreen
extends Screen {
    private static final ResourceLocation MTK_SWITCHER_LOCATION = new ResourceLocation("manaitamtk", "textures/gui/container/mtk_switcher.png");
    private static final int ALL_SLOTS_WIDTH = MTKIcon.values().length * 31 - 5;
    private MTKIcon previousMode;
    private MTKIcon currentlyMode;
    private int firstMouseX;
    private int firstMouseY;
    private boolean setFirstMousePos;
    private final List<MTKSlot> slots = Lists.newArrayList();
    private static final String UNDER_TEXT_FIRST = Component.m_237115_((String)"gui.mtk_switcher_screen.first_title").getString();
    private static final String UNDER_TEXT_SECOND = Component.m_237115_((String)"gui.mtk_switcher_screen.second_title").getString();
    private static final Component UNDER_TEXT_KEY = Component.m_237113_((String)MTKKeyMapping.MTKSwitcherSelectKey.getKey().m_84875_().getString()).m_130940_(ChatFormatting.AQUA);
    private static final Component UNDER_TEXT = Component.m_237113_((String)(UNDER_TEXT_FIRST + UNDER_TEXT_KEY.getString() + UNDER_TEXT_SECOND));

    public MTKSwitcherScreen() {
        super(GameNarrator.f_93310_);
        this.currentlyMode = this.previousMode;
    }

    public void m_88315_(GuiGraphics graphics, int x, int y, float f) {
        graphics.m_280168_().m_85836_();
        RenderSystem.enableBlend();
        int xInt = this.f_96543_ / 2 - 62;
        int yInt = this.f_96544_ / 2 - 31 - 27;
        graphics.m_280163_(MTK_SWITCHER_LOCATION, xInt, yInt, 0.0f, 0.0f, 125, 76, 128, 128);
        graphics.m_280168_().m_85849_();
        super.m_88315_(graphics, x, y, f);
        if (this.currentlyMode != null) {
            graphics.m_280653_(this.f_96547_, this.currentlyMode.getName(), this.f_96543_ / 2, this.f_96544_ / 2 - 31 - 20, -1);
        }
        graphics.m_280653_(this.f_96547_, UNDER_TEXT, this.f_96543_ / 2, this.f_96544_ / 2 + 5, 0xFFFFFF);
        if (!this.setFirstMousePos) {
            this.firstMouseX = x;
            this.firstMouseY = y;
            this.setFirstMousePos = true;
        }
        boolean $$6 = this.firstMouseX == x && this.firstMouseY == y;
        for (MTKSlot mTKSlot : this.slots) {
            if (!(mTKSlot instanceof MTKSlot)) continue;
            MTKSlot mtkSlot = mTKSlot;
            mtkSlot.m_88315_(graphics, x, y, f);
            mtkSlot.setSelected(this.currentlyMode == mtkSlot.icon);
            if ($$6 || !mtkSlot.m_198029_()) continue;
            this.currentlyMode = mtkSlot.icon;
        }
    }

    public void m_7856_() {
        super.m_7856_();
        this.setDefault();
        this.currentlyMode = this.previousMode;
        for (int i = 0; i < MTKIcon.VALUES.length; ++i) {
            MTKIcon mtkIcon = MTKIcon.VALUES[i];
            this.slots.add(new MTKSlot(mtkIcon, this.f_96543_ / 2 - ALL_SLOTS_WIDTH / 2 + i * 31, this.f_96544_ / 2 - 31));
        }
    }

    private void setDefault() {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ != null) {
            ItemStack stack = minecraft.f_91074_.m_21205_();
            if (stack.m_41720_() == ManaitaMTKItems.MANAITA_PICKAXE.get() || stack.m_41720_() == ManaitaMTKItems.MANAITA_PAXEL.get()) {
                this.previousMode = MTKIcon.getFromRange(stack.m_41784_().m_128451_("Range"));
            }
        } else if (this.previousMode == null) {
            this.previousMode = MTKIcon.ONE;
        }
    }

    private void saveTag(MTKIcon mtkIcon) {
        ItemStack stack;
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ != null && ((stack = minecraft.f_91074_.m_21205_()).m_41720_() == ManaitaMTKItems.MANAITA_PICKAXE.get() || stack.m_41720_() == ManaitaMTKItems.MANAITA_PAXEL.get())) {
            stack.m_41784_().m_128405_("Range", mtkIcon.getModeRange());
        }
    }

    public boolean m_7933_(int key1, int key2, int key3) {
        if (key1 == MTKKeyMapping.MTKSwitcherSelectKey.getKey().m_84873_()) {
            this.setFirstMousePos = false;
            this.currentlyMode = this.currentlyMode.getNext();
            this.saveTag(this.currentlyMode);
            return true;
        }
        return super.m_7933_(key1, key2, key3);
    }

    public void m_94757_(double x, double y) {
        super.m_94757_(x, y);
        for (MTKSlot slot : this.slots) {
            if (!slot.m_5953_(x, y)) continue;
            this.currentlyMode = slot.icon;
            this.saveTag(this.currentlyMode);
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_6050_(double x, double y, double delta) {
        if (delta < 0.0) {
            this.currentlyMode = this.currentlyMode.getNext();
        } else if (delta > 0.0) {
            this.currentlyMode = this.currentlyMode.getPrevious();
        }
        this.saveTag(this.currentlyMode);
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum MTKIcon {
        ONE((Component)Component.m_237113_((String)"1x1"), 1, new ItemStack((ItemLike)Items.f_42422_)),
        THREE((Component)Component.m_237113_((String)"3x3"), 3, new ItemStack((ItemLike)Items.f_42427_)),
        FIVE((Component)Component.m_237113_((String)"5x5"), 5, new ItemStack((ItemLike)Items.f_42385_)),
        SEVEN((Component)Component.m_237113_((String)"7x7"), 7, new ItemStack((ItemLike)Items.f_42432_)),
        NINE((Component)Component.m_237113_((String)"9x9"), 9, new ItemStack((ItemLike)Items.f_42390_));

        private static final MTKIcon[] VALUES;
        final Component name;
        final int modeRange;
        final ItemStack renderStack;

        private MTKIcon(Component name, int range, ItemStack stack) {
            this.name = name;
            this.modeRange = range;
            this.renderStack = stack;
        }

        public void drawIcon(GuiGraphics graphics, int x, int y) {
            graphics.m_280480_(this.renderStack, x, y);
        }

        public Component getName() {
            return this.name;
        }

        public int getModeRange() {
            return this.modeRange;
        }

        public ItemStack getRenderStack() {
            return this.renderStack;
        }

        public MTKIcon getNext() {
            return switch (this) {
                case ONE -> THREE;
                case THREE -> FIVE;
                case FIVE -> SEVEN;
                case SEVEN -> NINE;
                case NINE -> ONE;
                default -> ONE;
            };
        }

        private MTKIcon getPrevious() {
            return switch (this) {
                case ONE -> NINE;
                case THREE -> ONE;
                case FIVE -> THREE;
                case SEVEN -> FIVE;
                case NINE -> SEVEN;
                default -> ONE;
            };
        }

        public static MTKIcon getFromRange(int range) {
            return switch (range) {
                case 1 -> ONE;
                case 3 -> THREE;
                case 5 -> FIVE;
                case 7 -> SEVEN;
                case 9 -> NINE;
                default -> ONE;
            };
        }

        static {
            VALUES = MTKIcon.values();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class MTKSlot
    extends AbstractWidget {
        final MTKIcon icon;
        private boolean isSelected;

        public MTKSlot(MTKIcon mtkIcon, int x, int y) {
            super(x, y, 26, 26, mtkIcon.getName());
            this.icon = mtkIcon;
        }

        public void m_87963_(GuiGraphics graphics, int x, int y, float f) {
            this.drawSlot(graphics);
            this.icon.drawIcon(graphics, this.m_252754_() + 5, this.m_252907_() + 5);
            if (this.isSelected) {
                this.drawSelection(graphics);
            }
        }

        public void m_168797_(NarrationElementOutput output) {
            this.m_168802_(output);
        }

        public boolean m_198029_() {
            return super.m_198029_() || this.isSelected;
        }

        public boolean m_5953_(double x, double y) {
            return this.f_93623_ && this.f_93624_ && x >= (double)this.m_252754_() && x < (double)(this.m_252754_() + this.f_93618_);
        }

        public void setSelected(boolean selected) {
            this.isSelected = selected;
        }

        private void drawSlot(GuiGraphics graphics) {
            graphics.m_280163_(MTK_SWITCHER_LOCATION, this.m_252754_(), this.m_252907_(), 0.0f, 79.0f, 26, 26, 128, 128);
        }

        private void drawSelection(GuiGraphics graphics) {
            graphics.m_280163_(MTK_SWITCHER_LOCATION, this.m_252754_(), this.m_252907_(), 26.0f, 79.0f, 26, 26, 128, 128);
        }
    }
}

