package be.immersivechess.advancement.criterion;

import be.immersivechess.ImmersiveChess;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.util.Optional;
import net.minecraft.class_195;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5257;
import net.minecraft.class_5258;

public class ChessGameCriterion extends class_4558<ChessGameCriterion.Condition> {
    public enum Type {
        START,
        WIN,
        LOSE
    }

    @Override
    protected ChessGameCriterion.Condition method_27854(JsonObject obj, Optional<class_5258> predicate, class_5257 predicateDeserializer) {
        JsonPrimitive typeJson = obj.getAsJsonPrimitive("type");
        String typeStr = typeJson.getAsString().toUpperCase();

        try {
            Type type = Type.valueOf(typeStr);
            return new ChessGameCriterion.Condition(predicate, type);
        } catch (IllegalArgumentException e) {
            throw new JsonParseException("Invalid type found: " + typeStr);
        }
    }

    public void trigger(class_3222 player, Type type) {
        method_22510(player, condition -> condition.test(type));
    }

    public static class Condition extends class_195 {

        private final Type type;

        public Condition(Optional<class_5258> predicate, Type type) {
            super(predicate);
            this.type = type;
        }

        public boolean test(Type type) {
            return this.type == type;
        }

        @Override
        public JsonObject method_807() {
            JsonObject jsonObject = super.method_807();
            jsonObject.add("type", new JsonPrimitive(type.toString()));
            return jsonObject;
        }
    }
}
