package be.immersivechess.block;

import be.immersivechess.ImmersiveChess;
import be.immersivechess.logic.Piece;
import ch.astorm.jchess.core.Color;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.block.*;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_7923;
import java.util.*;
import java.util.stream.Collectors;

public class Blocks {

    public static final SortedMap<Piece, PieceBlock> PIECES = Arrays.stream(Piece.values()).collect(Collectors.toMap(
            p -> p,
            Blocks::createPieceBlock,
            (v1,v2) ->{ throw new RuntimeException(String.format("Duplicate key for values %s and %s", v1, v2));},
            TreeMap::new)
    );

    public static final StandBlock BLANK_STAND = register(
            new class_2960(ImmersiveChess.MOD_ID, "stand"),
            new StandBlock(FabricBlockSettings
                    .method_9637()
                    .method_31710(class_3620.field_15994)
                    .method_50012(class_3619.field_15971)
                    .method_9632(0.3f)
                    .method_22488()));

    public static final List<PieceStandBlock> PIECE_STANDS = Arrays.stream(Piece.values()).map(Blocks::createPieceStandBlock).toList();

    public static final List<PieceStructureBlock> PIECE_STRUCTURE_BLOCKS = Arrays.stream(Piece.values()).map(Blocks::createPieceStructureBlock).toList();

    public static BoardBlock BOARD_BLOCK = register("board", new BoardBlock(FabricBlockSettings
            .method_9637()
            .method_9629(-1.0f, 3600000.0f)
            .method_22488()
            .method_9624()        // to disable shape cache -> for overriding opacity
            .method_45477()
            .method_42327()
            .method_26235(Blocks::never)
    ));

    private static PieceBlock createPieceBlock(Piece piece) {
        return register(piece.getIdentifier().method_45138("piece/"), new PieceBlock(
                FabricBlockSettings
                        .method_9637()
                        .method_31710(class_3620.field_16008)
                        .method_50012(class_3619.field_15972)
                        .method_36557(0f)
                        .method_36558(3600000.0f)
                        .method_22488()
                        .method_45477(),
                piece)
        );
    }

    private static PieceStandBlock createPieceStandBlock(Piece piece) {
        return register(piece.getIdentifier().method_45138("stand/"), new PieceStandBlock(
                FabricBlockSettings
                        .method_9637()
                        .method_31710(piece.getColor() == Color.WHITE ? class_3620.field_16022 : class_3620.field_16009)
                        .method_50012(class_3619.field_15971)
                        .method_9632(0.3f)
                        .method_22488(),
                piece)
        );
    }

    private static PieceStructureBlock createPieceStructureBlock(Piece piece) {
        return register(piece.getIdentifier().method_45138("structure/"), new PieceStructureBlock(
                FabricBlockSettings
                        .method_9637()
                        .method_9632(3f)
                        .method_9624(),
                piece));
    }

    private static <A> boolean never(class_2680 var1, class_1922 var2, class_2338 var3, A var4) {
        return false;
    }

    private static <B extends class_2248> B register(class_2960 id, B block) {
        return class_2378.method_10230(class_7923.field_41175, id, block);
    }

    private static <B extends class_2248> B register(String name, B block) {
        return register(new class_2960(ImmersiveChess.MOD_ID, name), block);
    }

    public static void onInitialize() {

    }
}
