package be.immersivechess.block;

import be.immersivechess.ImmersiveChess;
import be.immersivechess.block.entity.BoardBlockEntity;
import be.immersivechess.item.Items;
import be.immersivechess.item.PieceItem;
import be.immersivechess.logic.MultiblockBoard;
import be.immersivechess.screen.ChessGameScreenHandler;
import be.immersivechess.world.ChessGameState;
import be.immersivechess.world.PieceRenderOption;
import ch.astorm.jchess.core.Color;
import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachedBlockView;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.block.*;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_247;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class BoardBlock extends class_2237 {

    private enum ColorState implements class_3542{
        WHITE,
        BLACK;

        @Override
        public String method_15434() {
            return toString().toLowerCase();
        }

        public static ColorState from(Color color){
            return color == Color.WHITE ? ColorState.WHITE : ColorState.BLACK;
        }
    }

    public static final class_2754<ColorState> COLOR = class_2754.method_11850("color", ColorState.class);

    // do not use simplify or union (which calls simplify) because we want intermediate collision surfaces.
    private static final class_265 COLLISION_SHAPE = class_259.method_1082(
            class_259.method_1082(
                    class_2248.method_9541(0, 0, 0, 16, 16, 16),
                    class_2248.method_9541(1, 16, 1, 15, 24, 15),
                    class_247.field_1366),
            class_2248.method_9541(2, 24, 2, 14, 32, 14),
            class_247.field_1366);

    public BoardBlock(class_2251 settings) {
        super(settings);
        method_9590(field_10647.method_11664().method_11657(COLOR, ColorState.BLACK));
    }

    @Override
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if(player.method_6047().method_31574(Items.CHESS_CASE) || player.method_6047().method_7909() instanceof PieceItem)
            return class_1269.field_5811;

        if (!world.field_9236){
            if (!(world.method_8321(pos) instanceof BoardBlockEntity boardBlockEntity))
                return class_1269.field_5814;

            // before opening screen, also perform some integrity checks
            ChessGameState gameState = boardBlockEntity.getGameState();
            if (gameState == null){
                ImmersiveChess.LOGGER.error("Failed to load game state associated with board -> reverting board blocks");
                MultiblockBoard board = MultiblockBoard.getValidBoard(world, player, pos);
                if (board != null)
                    board.endBoardBlocks(world);
                else
                    BoardBlock.placeBack(world, pos);

                return class_1269.field_5814;
            }

            gameState.performIntegrityCheck();

            class_3908 screenHandlerFactory = method_17454(state, world, pos);
            if (screenHandlerFactory == null)
                return class_1269.field_5814;

            player.method_17355(screenHandlerFactory);
            return class_1269.method_29236(true);
        }

        return class_1269.method_29236(true);
    }

    @Nullable
    @Override
    public class_3908 method_17454(class_2680 state, class_1937 world, class_2338 pos) {
        if (!(world.method_8321(pos) instanceof BoardBlockEntity boardBlockEntity))
            return null;

        ChessGameState gameState = boardBlockEntity.getGameState();
        if (gameState == null)
            return null;

        return new ExtendedScreenHandlerFactory() {
            @Override
            public class_1703 createMenu(int i, class_1661 playerInventory, class_1657 playerEntity) {
                return new ChessGameScreenHandler(i, gameState);
            }

            @Override
            public class_2561 method_5476() {
                return class_2561.method_30163("Chess Game");
            }

            @Override
            public void writeScreenOpeningData(class_3222 serverPlayerEntity, class_2540 packetByteBuf) {
                packetByteBuf.method_10814(Optional.ofNullable(gameState.getPlayerName(Color.WHITE)).orElse(""));
                packetByteBuf.method_10814(Optional.ofNullable(gameState.getPlayerName(Color.BLACK)).orElse(""));
                packetByteBuf.method_53002(gameState.getCurrentMoveIndex());
                packetByteBuf.method_10817(gameState.getColorOnMove());
                packetByteBuf.method_10817(gameState.getStatus());
                packetByteBuf.method_10814(gameState.getDrawOfferedTo());
                packetByteBuf.method_10806(gameState.getValidRenderOptions(Color.WHITE).stream().mapToInt(Enum::ordinal).toArray());
                packetByteBuf.method_10806(gameState.getValidRenderOptions(Color.BLACK).stream().mapToInt(Enum::ordinal).toArray());
                packetByteBuf.method_10817(gameState.getRenderOption(Color.WHITE));
                packetByteBuf.method_10817(gameState.getRenderOption(Color.BLACK));
            }
        };
    }

    @Override
    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        super.method_9612(state, world, pos, sourceBlock, sourcePos, notify);
    }

    private void clearAbove(class_1937 world, class_2338 pos) {
        clearAbove(world, pos, false);
    }

    private void clearAbove(class_1937 world, class_2338 pos, boolean removeAll) {
        pos = pos.method_10084();

        if (!removeAll) {
            // only chess pieces are allowed on the board unless removeAll is true
            class_2680 state = world.method_8320(pos);
            if(state.method_26204() instanceof PieceBlock || state.method_26204().equals((class_2246.field_10124)))
                return;
        }

        breakBlockAboveBoard(world, pos);
    }

    @Override
    public float method_9575(class_2680 state, class_1922 world, class_2338 pos) {
        return super.method_9575(state, world, pos);
    }

    /**
     * Can be called instead of world.breakBlock when the block is directly above a board.
     * Overrides item drop logic to drop the loot one block higher to accommodate for the taller collision box.
     */
    public static void breakBlockAboveBoard(class_1937 world, class_2338 pos){
        // drop loot
        if (!world.field_9236) {

            // based on `Block.dropStacks` to drop loot one block higher
            class_2680 state = world.method_8320(pos);
            class_2586 blockEntity = state.method_31709() ? world.method_8321(pos) : null;
            List<class_1799> loot = class_2248.method_9609(state, (class_3218) world, pos, blockEntity, null, class_1799.field_8037);
            final class_2338 dropLocation = pos.method_10084();
            loot.forEach(stack -> class_2248.method_9577(world, dropLocation, stack));
            state.method_26180((class_3218) world, pos, class_1799.field_8037, true);
        }

        world.method_22352(pos, false);
    }

    /**
     * Places a boardBlock to take the place of an existing block in the world. Stores info of original block
     */
    public void replace(class_1937 world, class_2338 pos, Color color) {
        world.method_8652(pos, field_10647.method_11664().method_11657(COLOR, ColorState.from(color)), class_2248.field_31036);
    }

    @Override
    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        if (oldState.method_27852(state.method_26204()))
            return;

        moveEntitiesAbove(state, world, pos, oldState);

        // When we actually replace air, use default model instead of invisible air model.
        // Should only happen when manually placed
        if (oldState == class_2246.field_10124.method_9564())
            oldState = state;

        // Clear invalid blocks directly above the board
        clearAbove(world, pos, true);

        class_2586 entity = world.method_8321(pos);
        if (entity instanceof BoardBlockEntity boardBlockEntity) {
            boardBlockEntity.setOriginalBlockState(oldState);
        }
    }

    /**
     * Based on Block.pushEntitiesUpBeforeBlockChange, but using move instead of teleport
     */
    private void moveEntitiesAbove(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState){
        class_265 voxelShape = class_259.method_1082(oldState.method_26220(world, pos), state.method_26220(world, pos), class_247.field_16893).method_1096(pos.method_10263(), pos.method_10264(), pos.method_10260());
        if (voxelShape.method_1110())
            return;

        List<class_1297> list = world.method_8335(null, voxelShape.method_1107());
        for (class_1297 entity : list) {
            double d = class_259.method_1085(class_2350.class_2351.field_11052, entity.method_5829().method_989(0.0, 1.0, 0.0), List.of(voxelShape), -1.0);
            if (entity instanceof class_1309){
                // LivingEntities tend to be larger and can be moved.
                entity.method_5784(class_1313.field_6309, new class_243(0.0, 1.0 + d, 0.0));
            }else{
                // Things like ItemEntities need teleportation (otherwise get stuck colliding with parts of shape)
                entity.method_45166(0.0, 1.0 + d, 0.0);
            }
        }
    }

    @Override
    public void method_9591(class_1937 world, class_2338 pos, class_2680 state, class_1297 entity) {
        // Move the player to the increased bounding box of the board.
        // (doesn't trigger when the entity is not directly above the block, which works out great for us)
        if (entity instanceof class_1309){
            // LivingEntities tend to be larger and can be moved.
            entity.method_5784(class_1313.field_6309, new class_243(class_2350.field_11036.method_23955()));
        }else{
            // Things like ItemEntities need teleportation (otherwise get stuck colliding with parts of shape)
            entity.method_45166(0.0, 1, 0.0);
        }
    }

    /**
     * Restores the original state of a position in the world where a BoardBlock exists.
     */
    public static void placeBack(class_1936 world, class_2338 pos) {
        class_2586 entity = world.method_8321(pos);
        if (entity instanceof BoardBlockEntity boardBlockEntity) {
            class_2680 originalState = boardBlockEntity.getOriginalBlockState();
            world.method_8652(pos, originalState, class_2248.field_31028);
        } else {
            ImmersiveChess.LOGGER.error("No block Entity available to place correct blockState back from board.");
        }
    }

    @Override
    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        super.method_9536(state, world, pos, newState, moved);

        if (!newState.method_27852(be.immersivechess.block.Blocks.BOARD_BLOCK)){
            clearAbove(world, pos, true);
        }
    }

    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Nullable
    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new BoardBlockEntity(pos, state);
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(COLOR);
    }

    @Override
    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return COLLISION_SHAPE;
    }

    @Override
    public boolean method_37403(class_2680 state, class_1922 world, class_2338 pos) {
        return true;
    }

    @Override
    public int method_9505(class_2680 state, class_1922 world, class_2338 pos) {
        if (world.method_8321(pos) instanceof BoardBlockEntity boardBlockEntity){
            class_2680 appearanceBlockState = boardBlockEntity.getOriginalBlockState();
            return appearanceBlockState.method_26193(world, pos);
        }

        return super.method_9505(state, world, pos);
    }

    @Override
    public class_2680 getAppearance(class_2680 state, class_1920 renderView, class_2338 pos, class_2350 side, @Nullable class_2680 sourceState, @Nullable class_2338 sourcePos) {
        // This function only reports what the block looks like, it doesn't actually change it. See BoardModel
        RenderAttachedBlockView attachmentView = (RenderAttachedBlockView) renderView;
        Object data = attachmentView.getBlockEntityRenderAttachment(pos);

        // Check if data is not null and of the correct type, and use that to determine the appearance
        if (data instanceof class_2680 appearanceBlockState) {
            return appearanceBlockState;
        }

        return state;
    }

}
