package be.immersivechess.block;

import be.immersivechess.block.entity.BlockEntityTypes;
import be.immersivechess.block.entity.BoardBlockEntity;
import be.immersivechess.block.entity.PieceBlockEntity;
import be.immersivechess.block.entity.StructureRenderedBlockEntity;
import be.immersivechess.item.Items;
import be.immersivechess.item.PieceContainer;
import be.immersivechess.item.PieceItem;
import be.immersivechess.logic.MultiblockBoard;
import be.immersivechess.logic.Piece;
import be.immersivechess.world.ChessGameState;
import ch.astorm.jchess.core.Color;
import ch.astorm.jchess.core.Coordinate;
import net.minecraft.block.*;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2753;
import net.minecraft.class_3218;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PieceBlock extends class_2237 implements PieceContainer {

    private final Piece piece;

    private final class_265 outlineShape;
    private final class_265 collisionShape;

    // Blockstate properties
    public static final class_2753 FACING = class_2383.field_11177;

    public PieceBlock(class_2251 settings, Piece piece) {
        super(settings);
        this.piece = piece;
        outlineShape = class_2248.method_9541(0, 0, 0, 16, 2 * piece.getHeight(), 16);
        // allow 3/16 of space so board collision can help the player move up over pieces
        collisionShape = class_2248.method_9541(3, 0, 3, 13, 2 * piece.getHeight(), 13);
        method_9590(field_10647.method_11664().method_11657(FACING, class_2350.field_11043));
    }

    public Piece getPiece() {
        return piece;
    }

    @Override
    public boolean method_9579(class_2680 state, class_1922 world, class_2338 pos) {
        return true;
    }

    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Override
    public PieceBlockEntity method_10123(class_2338 pos, class_2680 state) {
        return new PieceBlockEntity(pos, state);
    }

    @Override
    public class_1799 method_9574(class_1922 world, class_2338 pos, class_2680 state) {
        class_1799 itemStack = super.method_9574(world, pos, state);
        world.method_35230(pos, BlockEntityTypes.PIECE_BLOCK_ENTITY_TYPE).ifPresent(blockEntity -> {
            blockEntity.method_38240(itemStack);
            // setStackNbt also sets the id of the entity which is not needed and causes duplication. Remove it.
            if (itemStack.method_7985() && itemStack.method_7969().method_10545(class_1747.field_30849))
                itemStack.method_7941(class_1747.field_30849).method_10551("id");
        });
        return itemStack;
    }

    @Override
    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        super.method_9567(world, pos, state, placer, itemStack);

        ChessGameState gameState = getGameState(world, pos);
        if (gameState == null) return;
        Coordinate source = PieceContainer.getSourceSquare(itemStack);
        if (source == null) return;
        gameState.doMove(source, getSquare(world, pos), piece);
    }

    @Override
    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        if (world.method_8608()) return false;
        if (!(world.method_8321(pos.method_10074()) instanceof BoardBlockEntity boardBlockEntity)) return false;
        ChessGameState gameState = boardBlockEntity.getGameState();
        if (gameState == null) return false;

        return true;
    }

    /**
     * Checks whether it's the player's turn and they haven't mined a piece already
     */
    private boolean canMinePiece(class_1937 world, class_2338 pos, class_1657 player) {
        ChessGameState gameState = getGameState(world, pos);
        if (gameState == null) return true;
        Coordinate square = getSquare(world, pos);
        if (square == null) return true;
        return gameState.canMinePiece(square, player);
    }

    private boolean canCapturePiece(class_1937 world, class_2338 pos, class_1657 player) {
        ChessGameState gameState = getGameState(world, pos);
        if (gameState == null) return false;
        class_1799 movingPiece = player.method_6047();
        if (!(movingPiece.method_7909() instanceof PieceItem pieceItem)) return false;

        return PieceContainer.getDestinationSquares(movingPiece).contains(getSquare(world, pos));
    }

    /**
     * Get square of piece based on board block below it
     */
    @Nullable
    private Coordinate getSquare(class_1937 world, class_2338 pos) {
        class_2586 blockEntity = world.method_8321(pos.method_10074());
        if (blockEntity instanceof BoardBlockEntity boardBlockEntity)
            return boardBlockEntity.getSquare();
        return null;
    }

    /**
     * Get ChessGameState based on board
     */
    @Nullable
    private ChessGameState getGameState(class_1937 world, class_2338 pos) {
        class_2586 blockEntity = world.method_8321(pos.method_10074());
        if (blockEntity instanceof BoardBlockEntity boardBlockEntity)
            return boardBlockEntity.getGameState();
        return null;
    }

    @Override
    public boolean method_9616(class_2680 state, class_1750 context) {
        // Allows player to replace opponent pieces.
        // Does not check for valid moves, only whether replacement is allowed to happen.
        if (!(context.method_8041().method_7909() instanceof PieceItem pieceItem))
            return false;

        Color myColor = ((PieceBlock) state.method_26204()).getPiece().getColor();
        return pieceItem.getPiece().getColor() != myColor;
    }

    @Override
    public void method_9606(class_2680 state, class_1937 world, class_2338 pos, class_1657 player) {
        if (world.field_9236)
            return;

        ChessGameState gameState = getGameState(world, pos);
        // If not part of game, do regular mining
        if (gameState == null) {
            world.method_8651(pos, false, player);
            return;
        }

        // If piece in hand, call replace instead of trying to mine opponent piece.
        if (canCapturePiece(world, pos, player)) {
            PieceItem pieceItem = (PieceItem) player.method_6047().method_7909();
            if (replaceOpponentPiece(world, pos, player, pieceItem, gameState))
                return;
        }

        // Try to mine piece if valid
        if (canMinePiece(world, pos, player)) {
            minePiece(world, pos, player, gameState);
        }
    }

    private void minePiece(class_1937 world, class_2338 pos, class_1657 player, ChessGameState gameState) {
        if (!world.field_9236) {
            // loot
            class_2680 state = world.method_8320(pos);
            class_2586 blockEntity = state.method_31709() ? world.method_8321(pos) : null;
            List<class_1799> loot = class_2248.method_9609(state, (class_3218) world, pos, blockEntity, null, class_1799.field_8037);
            state.method_26180((class_3218) world, pos, player.method_6047(), true);
            loot.forEach(stack -> player.method_31548().method_7398(stack));
            // update gamestate
            gameState.setMinedSquare(pos);
        }

        world.method_22352(pos, false);
    }

    private boolean replaceOpponentPiece(class_1937 world, class_2338 pos, class_1657 player, PieceItem pieceItem, ChessGameState gameState) {
        class_1799 stack = player.method_6047();
        class_2680 blockState = pieceItem.method_7711().method_9564();
        class_1750 context = new class_1750(player, class_1268.field_5808, stack, new class_3965(class_243.method_24955(pos), class_2350.field_11036, pos, false));
        if (method_9558(blockState, world, pos) && method_9616(world.method_8320(pos), context)) {
            if (pieceItem.method_7712(context).method_23665())
                return true;
        }
        return false;
    }

    @Override
    public float method_9594(class_2680 state, class_1657 player, class_1922 world, class_2338 pos) {
        // We have custom block breaking code. This is used to prevent MC from breaking blocks
        return 0;
    }

    @Override
    public void method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        super.method_9576(world, pos, state, player);
    }

    @Override
    public List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        // if not on an ongoing game, don't drop anything
        class_2338 pos = class_2338.method_49638(builder.method_51873(class_181.field_24424));
        ChessGameState gameState = getGameState(builder.method_51870(), pos);
        if (gameState == null || gameState.getStatus().isFinished()) return Collections.emptyList();

        // if possible destination of pawn is backline -> drop promotion pieces instead
        List<class_1799> normalLoot = super.method_9560(state, builder);
        for (class_1799 stack : normalLoot) {
            if (isPromotablePawn(stack)) {
                return getPromotionPieces(gameState, stack);
            }
        }

        return normalLoot;
    }

    private boolean isPromotablePawn(class_1799 stack) {
        if (!(piece == Piece.WHITE_PAWN || piece == Piece.BLACK_PAWN)) return false;
        // Redundant checks if Minecraft does not mess up
//        if (!(stack.getItem() instanceof PieceItem pieceItem)) return false;
//        if (pieceItem.getPiece() != piece) return false;

        List<Coordinate> destinations = PieceContainer.getDestinationSquares(stack);
        for (Coordinate destination : destinations) {
            if (destination.getRow() == 0 || destination.getRow() == MultiblockBoard.BOARD_SIZE - 1)
                return true;
        }
        return false;
    }

    /**
     * Pieces that can be placed when promotion is possible. This includes:
     * - the original pawn with the origin square and no other destinations (for placing back)
     * - all other pieces of the same color with the pawn destinations
     */
    private List<class_1799> getPromotionPieces(ChessGameState gameState, class_1799 pawn) {
        gameState.getStructure(piece);

        Coordinate source = PieceContainer.getSourceSquare(pawn);
        List<Coordinate> destinations = PieceContainer.getDestinationSquares(pawn);
        destinations.remove(source);
        String gameId = PieceContainer.getGameSaveId(pawn);
        int moveIndex = PieceContainer.getMoveIndex(pawn);

        List<class_1799> loot = new ArrayList<>();

        PieceContainer.writeDestinations(pawn, List.of(source));
        loot.add(pawn);

        for (Piece promotionPiece : piece.getPromotions()) {
            class_1799 stack = new class_1799(Items.PIECE_ITEMS.get(promotionPiece), 1);
            PieceContainer.writeStructureNbt(stack, gameState.getStructure(promotionPiece));
            PieceContainer.writeGameSaveId(stack, gameId);
            PieceContainer.writeSourceSquare(stack, source);
            PieceContainer.writeDestinations(stack, destinations);
            PieceContainer.writeMoveIndex(stack, moveIndex);

            loot.add(stack);
        }

        return loot;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(FACING);
    }

    @Override
    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return state.method_11657(FACING, rotation.method_10503(state.method_11654(FACING)));
    }

    @Override
    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345(state.method_11654(FACING)));
    }

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        // This is the default behaviour. When the itemstack contains blockstate info in nbt, it is applied instead.
        class_2350 playerFacing = ctx.method_8042();
        class_2350 direction = ctx.method_8046() ? playerFacing.method_10153() : playerFacing;
        return method_9564().method_11657(FACING, direction);
    }

    @Override
    public boolean method_37403(class_2680 state, class_1922 world, class_2338 pos) {
        return false;
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return outlineShape;
    }

    @Override
    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return collisionShape;
    }

//    @Override
//    public VoxelShape getRaycastShape(BlockState state, BlockView world, BlockPos pos) {
//        return shape;
//    }

}
