package be.immersivechess.block;

import be.immersivechess.block.entity.BlockEntityTypes;
import be.immersivechess.block.entity.PieceStandBlockEntity;
import be.immersivechess.item.PieceContainer;
import be.immersivechess.logic.Piece;
import net.minecraft.block.*;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2753;
import net.minecraft.class_3726;
import org.jetbrains.annotations.Nullable;

public class PieceStandBlock extends StandBlock {

    private final Piece piece;

    private final class_265 outlineShape;

    // Blockstate properties
    public static final class_2753 FACING = class_2383.field_11177;

    public PieceStandBlock(class_2251 settings, Piece piece) {
        super(settings);
        this.piece = piece;
        outlineShape = class_259.method_1084(
                StandBlock.OUTLINE_SHAPE,
                class_2248.method_9541(4, 0, 4, 12, 3 + piece.getHeight(), 12)
        );
        method_9590(field_10647.method_11664().method_11657(FACING, class_2350.field_11043));
    }

    @Override
    public Piece getPiece() {
        return piece;
    }

//    @Override
//    public BlockRenderType getRenderType(BlockState state) {
//        return BlockRenderType.MODEL;
//    }
//
//    // from BlockWithEntity
//    @Override
//    public boolean onSyncedBlockEvent(BlockState state, World world, BlockPos pos, int type, int data) {
//        super.onSyncedBlockEvent(state, world, pos, type, data);
//        BlockEntity blockEntity = world.getBlockEntity(pos);
//        if (blockEntity == null) {
//            return false;
//        }
//        return blockEntity.onSyncedBlockEvent(type, data);
//    }
//
//    @Override
//    public PieceStandBlockEntity createBlockEntity(BlockPos pos, BlockState state) {
//        return new PieceStandBlockEntity(pos, state);
//    }
//
//    @Override
//    public ItemStack getPickStack(BlockView world, BlockPos pos, BlockState state) {
//        ItemStack itemStack = super.getPickStack(world, pos, state);
//        world.getBlockEntity(pos, BlockEntityTypes.PIECE_STAND_BLOCK_ENTITY_TYPE).ifPresent(blockEntity -> {
//            blockEntity.setStackNbt(itemStack);
//            // setStackNbt also sets the id of the entity which is not needed and causes duplication. Remove it.
//            if (itemStack.hasNbt() && itemStack.getNbt().contains(BlockItem.BLOCK_ENTITY_TAG_KEY))
//                itemStack.getSubNbt(BlockItem.BLOCK_ENTITY_TAG_KEY).remove("id");
//        });
//        return itemStack;
//    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(FACING);
    }

    @Override
    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return state.method_11657(FACING, rotation.method_10503(state.method_11654(FACING)));
    }

    @Override
    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345(state.method_11654(FACING)));
    }

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        // default placement facing is inverted compared to Piece
        // because stands should face the player whereas pieces should face away from you
        class_2350 playerFacing = ctx.method_8042();
        class_2350 direction = ctx.method_8046() ? playerFacing : playerFacing.method_10153();
        return method_9564().method_11657(FACING, direction);
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return outlineShape;
    }
}
