package be.immersivechess.block;

import be.immersivechess.ImmersiveChess;
import be.immersivechess.block.entity.PieceStructureBlockEntity;
import be.immersivechess.item.Items;
import be.immersivechess.item.PieceContainer;
import be.immersivechess.logic.Piece;
import net.minecraft.block.*;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_5714;
import net.minecraft.class_5819;
import net.minecraft.util.*;
import net.minecraft.util.math.*;
import org.jetbrains.annotations.Nullable;

public class PieceStructureBlock extends class_2237 implements PieceContainer {

    public static final int PIECE_BASE_SIZE = 8;
    private static final class_265 EMPTY_COLLISION_SHAPE = class_2248.method_9541(0, 0, 0, 16, 15, 16);
    private final class_265 filledCollisionShape;

    private final Piece piece;

    // Blockstate properties
    private static final class_2753 FACING = class_2383.field_11177;
    private static final class_2746 EMPTY = class_2746.method_11825("empty");

    public PieceStructureBlock(class_2251 settings, Piece piece) {
        super(settings);
        this.piece = piece;
        filledCollisionShape = class_259.method_17786(
                EMPTY_COLLISION_SHAPE,
                class_2248.method_9541(3, 13, 3, 13, 16, 13),                      // stand
                class_2248.method_9541(4, 16, 4, 12, 16 + piece.getHeight(), 12)   // piece
        );
        method_9590(field_10647.method_11664().method_11657(FACING, class_2350.field_11043).method_11657(EMPTY, true));
    }

    @Nullable
    @Override
    public <T extends class_2586> class_5714 method_32896(class_3218 world, T blockEntity) {
        if (blockEntity instanceof PieceStructureBlockEntity structureBlockEntity) {
            return structureBlockEntity.getEventListener();
        }
        return null;
    }

    /**
     * Called from PieceStructureBlockEntity when the structure needs to be updated.
     */
    @Override
    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (state.method_11654(EMPTY))
            return;

        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof PieceStructureBlockEntity structureBlockEntity)
            structureBlockEntity.updateStructure();
    }

    @Override
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2586 entity = world.method_8321(pos);
        if (!(entity instanceof PieceStructureBlockEntity structureBlockEntity))
            return class_1269.field_5814;

        if (state.method_11654(EMPTY)) {
            class_1799 playerHolding = player.method_5998(hand);
            if (!playerHolding.method_7909().equals(Items.BLANK_STAND)){
                return class_1269.field_21466;
            }

            // insert
            if (!world.field_9236) {
                class_1799 toInsert = playerHolding.method_46651(1);
                if (!player.method_7337())
                    playerHolding.method_7934(1);
                structureBlockEntity.setContent(toInsert);
                structureBlockEntity.updateStructure();
                world.method_8501(pos, state.method_11657(EMPTY, false));
            }
        } else {
            // extract
            if (!world.field_9236) {
                player.method_31548().method_7398(structureBlockEntity.clearContent());
                world.method_8501(pos, state.method_11657(EMPTY, true));
            }
        }

        return class_1269.field_5812;
    }

    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Nullable
    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new PieceStructureBlockEntity(pos, state);
    }

    @Override
    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        super.method_9567(world, pos, state, placer, itemStack);
        if (placer != null && world.method_8321(pos) instanceof PieceStructureBlockEntity pieceStructureBlockEntity)
            pieceStructureBlockEntity.setAuthor(placer);
    }

    @Override
    public Piece getPiece() {
        return piece;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(FACING, EMPTY);
    }

    public static class_2350 getFacing(class_2680 state) {
        return state.method_11654(FACING);
    }

    public class_3341 getBuildingBox(class_2680 state, class_2338 pos) {
        class_2350 facing = getFacing(state);
        class_2338 c1 = pos.method_10093(facing);
        class_2338 c2 = c1
                .method_10079(facing, PIECE_BASE_SIZE - 1)
                .method_10079(facing.method_10160(), PIECE_BASE_SIZE - 1)
                .method_10069(0, piece.getHeight() - 1, 0);
        return class_3341.method_34390(c1, c2);
    }

    @Override
    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return state.method_11657(FACING, rotation.method_10503(state.method_11654(FACING)));
    }

    @Override
    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345(state.method_11654(FACING)));
    }

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        class_2350 playerFacing = ctx.method_8042();
        class_2350 direction = ctx.method_8046() ? playerFacing.method_10153() : playerFacing;
        return method_9564().method_11657(FACING, direction);
    }

    /**
     * Drop contents
     */
    @Override
    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        super.method_9536(state, world, pos, newState, moved);

        if (state.method_27852(newState.method_26204()))
            return;

        if (state.method_11654(EMPTY))
            return;

        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof PieceStructureBlockEntity structureBlockEntity) {
            if (world instanceof class_3218) {
                class_1264.method_5451(world, pos, new class_1277(structureBlockEntity.getContent()));
            }
        }
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return EMPTY_COLLISION_SHAPE;
    }

    @Override
    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        if (state.method_11654(EMPTY))
            return EMPTY_COLLISION_SHAPE;
        return filledCollisionShape;
    }

    @Override
    public boolean method_37403(class_2680 state, class_1922 world, class_2338 pos) {
        return false;
    }
}
