package be.immersivechess.block;

import be.immersivechess.block.entity.BlockEntityTypes;
import be.immersivechess.block.entity.PieceStandBlockEntity;
import be.immersivechess.item.PieceContainer;
import be.immersivechess.logic.Piece;
import net.minecraft.block.*;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3726;
import org.jetbrains.annotations.Nullable;

public class StandBlock extends class_2237 implements PieceContainer {

    public static final class_265 OUTLINE_SHAPE = class_259.method_17786(
            class_2248.method_9541(3, 0, 4, 13, 3, 12),
            class_2248.method_9541(4, 0, 3, 12, 3, 13),
            class_2248.method_9541(2, 0, 6, 14, 2, 10),
            class_2248.method_9541(6, 0, 2, 10, 2, 14)
    );

    public StandBlock(class_2251 settings) {
        super(settings);
    }

    @Nullable
    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new PieceStandBlockEntity(pos, state);
    }

    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Override
    public Piece getPiece() {
        return null;
    }

    @Override
    public class_1799 method_9574(class_1922 world, class_2338 pos, class_2680 state) {
        class_1799 itemStack = super.method_9574(world, pos, state);
        world.method_35230(pos, BlockEntityTypes.PIECE_STAND_BLOCK_ENTITY_TYPE).ifPresent(blockEntity -> {
            blockEntity.method_38240(itemStack);
            // setStackNbt also sets the id of the entity which is not needed and causes duplication. Remove it.
            if (itemStack.method_7985() && itemStack.method_7969().method_10545(class_1747.field_30849))
                itemStack.method_7941(class_1747.field_30849).method_10551("id");
        });
        return itemStack;
    }

    @Override
    public boolean method_9579(class_2680 state, class_1922 world, class_2338 pos) {
        return true;
    }

    @Override
    public boolean method_37403(class_2680 state, class_1922 world, class_2338 pos) {
        return false;
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return OUTLINE_SHAPE;
    }


}
