package be.immersivechess.block.entity;

import be.immersivechess.ImmersiveChess;
import be.immersivechess.logic.Piece;
import be.immersivechess.util.BlockStateUtil;
import be.immersivechess.world.ChessGameState;
import ch.astorm.jchess.core.Coordinate;
import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachmentBlockEntity;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Objects;

public class BoardBlockEntity extends class_2586 implements RenderAttachmentBlockEntity {

    private static final String GAME_ID_KEY = "GameId";
    private static final String BLOCKSTATE_KEY = "OriginalBlockState";
    private static final String SQUARE_KEY = "Square";
    private static final String PIECE_KEY = "Piece";
    private static final String IN_CHECK_KEY = "InCheck";
    private static final String WHITE_DIRECTION_KEY = "Direction";

    private ChessGameState gameState;

    // stored in NBT and synced to client when updated (for rendering)
    private String gameSaveId;          // date and id
    private class_2680 originalBlockState = class_2246.field_10124.method_9564();
    private Coordinate square;
    private class_2350 whitePlayDirection;
    private boolean inCheck;            // set by ChessGameState
    private Piece piece;                // only set when piece mined to indicate as placeholder

    public BoardBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntityTypes.BOARD_BLOCK_ENTITY_TYPE, pos, state);
    }

    public void setOriginalBlockState(@Nullable class_2680 blockState) {
        if (blockState == originalBlockState)
            return;

        if (blockState == null)
            blockState = class_2246.field_10124.method_9564();

        originalBlockState = blockState;
        method_5431();
        updateBlockModel();
    }

    public void setGameState(@NotNull ChessGameState gameState) {
        this.gameState = gameState;
        if (!gameState.getGameSaveId().equals(gameSaveId)) {
            this.gameSaveId = gameState.getGameSaveId();
            setWhitePlayDirection(gameState.getWhitePlayDirection());
            method_5431();
        }
    }


    public void setSquare(Coordinate square) {
        this.square = square;
        method_5431();
        syncToClient();
    }

    public Coordinate getSquare() {
        return square;
    }

    public void setPiece(Piece piece){
        if (this.piece != null && this.piece.equals(piece))
            return;

        this.piece = piece;
        method_5431();
        syncToClient();
    }

    public Piece getPiece() {
        return piece;
    }

    public void setInCheck(boolean isUnderAttack){
        if (this.inCheck == isUnderAttack)
            return;

        this.inCheck = isUnderAttack;
        method_5431();
        syncToClient();
    }

    public boolean isInCheck() {
        return inCheck;
    }

    public class_2350 getWhitePlayDirection(){
        return whitePlayDirection;
    }

    public String getGameSaveId() {
        return gameSaveId;
    }

    public ChessGameState getGameState() {
        return gameState;
    }

    public class_2680 getOriginalBlockState() {
        return originalBlockState;
    }

    public class_2622 method_38235() {
        return class_2622.method_38585(this);
    }

    @Override
    public class_2487 method_16887() {
        return this.method_38244();
    }

    @Override
    public void method_31662(class_1937 world) {
        super.method_31662(world);

        if (world instanceof class_3218 serverWorld && gameSaveId != null){
            gameState = ChessGameState.get(serverWorld, gameSaveId);
        }
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        if (nbt.method_10545(BLOCKSTATE_KEY)) {
            originalBlockState = class_2512.method_10681(class_7923.field_41175.method_46771(), nbt.method_10562(BLOCKSTATE_KEY));
            updateBlockModel();
        }

        if (nbt.method_10545(GAME_ID_KEY))
            // Actual game is loaded when world gets set (depends on persistent state)
            gameSaveId = nbt.method_10558(GAME_ID_KEY);

        if (nbt.method_10545(SQUARE_KEY))
            square = new Coordinate(nbt.method_10558(SQUARE_KEY));

        if (nbt.method_10545(WHITE_DIRECTION_KEY))
            whitePlayDirection = class_2350.method_10139(nbt.method_10550(WHITE_DIRECTION_KEY));

        if (nbt.method_10545(IN_CHECK_KEY))
            inCheck = nbt.method_10577(IN_CHECK_KEY);

        try{
            piece = nbt.method_10545(PIECE_KEY) ? Piece.fromName(nbt.method_10558(PIECE_KEY)) : null;
        } catch (IllegalArgumentException e){
            ImmersiveChess.LOGGER.error("Failed to load piece from nbt string", e);
        }
    }

    @Override
    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        if (originalBlockState != null)
            nbt.method_10566(BLOCKSTATE_KEY, class_2512.method_10686(originalBlockState));
        if (gameSaveId != null)
            nbt.method_10582(GAME_ID_KEY, gameSaveId);
        if (square != null)
            nbt.method_10582(SQUARE_KEY, square.toString());
        if (piece != null)
            nbt.method_10582(PIECE_KEY, piece.toString());
        if (whitePlayDirection != null)
            nbt.method_10569(WHITE_DIRECTION_KEY, whitePlayDirection.method_10161());
        nbt.method_10556(IN_CHECK_KEY, inCheck);
    }

    @Override
    public @Nullable Object getRenderAttachmentData() {
        return originalBlockState;
    }

    private void setWhitePlayDirection(class_2350 direction){
        if (!Objects.equals(whitePlayDirection, direction)){
            this.whitePlayDirection = direction;
            syncToClient();
        }
        // no mark dirty needed because this is set when gamestate loaded
    }

    private void updateBlockModel() {
        if (field_11863 == null)
            return;

        field_11863.method_8413(field_11867, method_11010(), method_11010(), class_2248.field_31028);
    }

    private void syncToClient(){
        // invoke sync of blockentity state to client
        if (field_11863 instanceof class_3218 serverWorld)
            serverWorld.method_14178().method_14128(field_11867);
    }
}
