package be.immersivechess.block.entity;

import be.immersivechess.item.PieceContainer;
import be.immersivechess.item.StandItem;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;

public abstract class DyedStructureRenderedBlockEntity extends StructureRenderedBlockEntity{

    private int color = StandItem.DEFAULT_COLOR_INT;

    public DyedStructureRenderedBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public int getColor(){
        return color;
    }

    public void setColor(int color){
        if (this.color != color) {
            this.color = color;
            method_5431();
            updateBlockModel();
        }
    }

    @Override
    public void method_11014(class_2487 nbt) {
        if (nbt.method_10545(PieceContainer.NBT_COLOR_KEY))
            color = nbt.method_10550(PieceContainer.NBT_COLOR_KEY);
        else
            color = StandItem.DEFAULT_COLOR_INT;

        // to prevent call to updateBlocKModel before all data set
        super.method_11014(nbt);
        updateBlockModel();
    }

    @Override
    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        // nbt data is passed along to item when mined
        if (color != StandItem.DEFAULT_COLOR_INT)
            nbt.method_10569(PieceContainer.NBT_COLOR_KEY, color);
    }

}
