package be.immersivechess.block.entity;

import be.immersivechess.item.PieceContainer;
import be.immersivechess.logic.Piece;
import be.immersivechess.world.ChessGameState;
import ch.astorm.jchess.core.Coordinate;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class PieceBlockEntity extends StructureRenderedBlockEntity {

    public static final String NBT_GAME_INFO = "GameInfo";

    public final Piece piece;

    public PieceBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntityTypes.PIECE_BLOCK_ENTITY_TYPE, pos, state);

        PieceContainer pieceGetter = (PieceContainer) state.method_26204();
        this.piece = pieceGetter.getPiece();
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
    }

    @Override
    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);

        // nbt data can be passed along to item when mined if configured in loot table
        if (!method_11002() || field_11863.field_9236)
            return;

        // during world save, don't store gameplay data to piece (only needed for item form)
        if (field_11863.method_8503().method_39219())
            return;

        // all information is fetched from the board
        class_2586 blockEntity = field_11863.method_8321(method_11016().method_10074());
        if (blockEntity instanceof BoardBlockEntity boardBlockEntity) {
            // Also write game data to nbt so it can be read by the mined item.
            // Does not need to be read as it is determined from game state.
            class_2487 gameInfo = new class_2487();

            // game id
            if (boardBlockEntity.getGameSaveId() != null)
                gameInfo.method_10582(PieceContainer.NBT_GAME_ID_KEY, boardBlockEntity.getGameSaveId());

            // origin
            Coordinate origin = boardBlockEntity.getSquare();
            if (origin != null)
                gameInfo.method_10582(PieceContainer.NBT_SOURCE_SQUARE_KEY, origin.toString());

            ChessGameState gameState = boardBlockEntity.getGameState();
            if (gameState != null) {
                // possible destination squares
                class_2499 destinations = new class_2499();
                gameState.getLegalDestinations(origin).stream()
                        .map(Coordinate::toString)
                        .forEach(s -> destinations.add(class_2519.method_23256(s)));
                gameInfo.method_10566(PieceContainer.NBT_DESTINATION_SQUARES_KEY, destinations);

                // moveIndex
                gameInfo.method_10569(PieceContainer.NBT_MOVE_INDEX_KEY, gameState.getCurrentMoveIndex());
            }

            nbt.method_10566(NBT_GAME_INFO, gameInfo);
        }
    }

    @Override
    public @Nullable Object getRenderAttachmentData() {
        // null is used to indicate the default model should be used so this case is handled
        return getStructureNbt();
    }
}
