package be.immersivechess.block.entity;

import be.immersivechess.block.PieceStructureBlock;
import be.immersivechess.item.Items;
import be.immersivechess.item.PieceContainer;
import be.immersivechess.item.StandItem;
import be.immersivechess.logic.Piece;
import be.immersivechess.structure.StructureHelper;
import org.jetbrains.annotations.NotNull;

import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_3499;
import net.minecraft.class_5707;
import net.minecraft.class_5712;
import net.minecraft.class_5714;
import net.minecraft.class_5716;

public class PieceStructureBlockEntity extends DyedStructureRenderedBlockEntity implements class_5714 {
    // keys for nbt data
    private static final String AUTHOR_KEY = "Author";

    // cached properties
    private final class_3341 buildingBox;
    private final class_5716 listenerSource;

    // stored to nbt
    private String authorName;

    public PieceStructureBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntityTypes.PIECE_STRUCTURE_BLOCK_ENTITY_TYPE, pos, state);

        buildingBox = ((PieceStructureBlock) state.method_26204()).getBuildingBox(state, pos);
        listenerSource = new class_5707(buildingBox.method_22874());
    }

    public void setAuthor(class_1309 placer){
        this.authorName = placer.method_5820();
    }

    public void updateStructure() {
        setStructure(buildStructureNbtFromWorld());
    }

    public class_1799 getContent() {
        class_1799 content = new class_1799(Items.PIECE_STANDS.get(getPiece()));
        PieceContainer.writeStructureNbt(content, getStructureNbt());
        PieceContainer.writeColor(content, getColor());
        return content;
    }

    public void setContent(@NotNull class_1799 stack) {
        setColor(PieceContainer.getColor(stack));
    }

    public class_1799 clearContent() {
        class_1799 stack = getContent();

        // reset info based on item
        setColor(StandItem.DEFAULT_COLOR_INT);

        return stack;
    }

    public PieceStructureBlock getPieceStructureBlock() {
        if (method_11010().method_26204() instanceof PieceStructureBlock pieceStructureBlock)
            return pieceStructureBlock;

        if (field_11863 == null)
            return null;

        return (PieceStructureBlock) field_11863.method_8320(field_11867).method_26204();
    }

    public Piece getPiece() {
        return getPieceStructureBlock().getPiece();
    }

    public class_2350 getFacing() {
        return PieceStructureBlock.getFacing(method_11010());
    }

    private class_2487 buildStructureNbtFromWorld() {
        class_3499 structureTemplate = new class_3499();
        class_3341 box = getPieceStructureBlock().getBuildingBox(method_11010(), field_11867);
        class_2338 start = new class_2338(box.method_35415(), box.method_35416(), box.method_35417());
        structureTemplate.method_15174(this.field_11863, start, box.method_14659().method_34592(1, 1, 1), false, class_2246.field_10124);
        // Note: author is not actually stored in structure NBT unfortunately (last checked in 1.19.4)
        if (authorName != null)
            structureTemplate.method_15161(authorName);

        StructureHelper.rotate(structureTemplate, facingToRotation(getFacing()));

        class_2487 structureNbt = structureTemplate.method_15175(new class_2487());
        return structureNbt;
    }

    private static class_2470 facingToRotation(class_2350 facing) {
        return switch (facing) {
            case field_11033 -> throw new IllegalStateException("Invalid facing direction of PieceStructureBlock: " + facing);
            case field_11036 -> throw new IllegalStateException("Invalid facing direction of PieceStructureBlock: " + facing);
            case field_11043 -> class_2470.field_11464;
            case field_11035 -> class_2470.field_11467;
            case field_11039 -> class_2470.field_11465;
            case field_11034 -> class_2470.field_11463;
        };
    }

    public int getPieceHeight() {
        return getPiece().getHeight();
    }

    public boolean isPowered() {
        if (!method_11002())
            return false;
        return method_10997().method_49803(method_11016());
    }

    public boolean shouldShowOutline() {
        return !isPowered();
    }

    // From GameEventListener

    @Override
    public class_5716 method_32946() {
        return listenerSource;
    }

    @Override
    public int method_32948() {
        // required to reach outermost corner for king which is 16 blocks high
        return 10;
    }

    @Override
    public boolean method_32947(class_3218 world, class_5712 event, class_5712.class_7397 emitter, class_243 emitterPos) {
        if (!List.of(class_5712.field_28164, class_5712.field_28733, class_5712.field_28165).contains(event))
            return false;

        class_2338 eventPos = class_2338.method_49638(emitterPos);
        if (!buildingBox.method_14662(eventPos))
            return false;

        // block break event gets called before the actual block break, so we delay by one
        int delay = event.equals(class_5712.field_28165) ? 1 : 0;
        world.method_39279(field_11867, getPieceStructureBlock(), delay);
        return true;
    }

    public class_5714 getEventListener() {
        return this;
    }

    @Override
    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        if (authorName != null)
            nbt.method_10582(AUTHOR_KEY, authorName);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        if (nbt.method_10545(AUTHOR_KEY))
            this.authorName = nbt.method_10558(AUTHOR_KEY);
    }
}
