package be.immersivechess.block.entity;

import be.immersivechess.item.PieceContainer;
import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachmentBlockEntity;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3499;
import org.jetbrains.annotations.Nullable;

import java.util.Objects;

public abstract class StructureRenderedBlockEntity extends class_2586 implements RenderAttachmentBlockEntity {
    private class_2487 structureNbt;

    public StructureRenderedBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        if (nbt.method_10545(PieceContainer.NBT_STRUCTURE_KEY)){
            structureNbt = nbt.method_10562(PieceContainer.NBT_STRUCTURE_KEY);
            updateBlockModel();
        }
    }

    @Override
    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        // nbt data is passed along to item when mined
        if (structureNbt != null)
            nbt.method_10566(PieceContainer.NBT_STRUCTURE_KEY, structureNbt);
    }

    @Override
    public class_2487 method_16887() {
        return method_38244();
    }

    @Nullable
    @Override
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585(this);
    }

    public void setStructure(class_2487 structureNbt) {
        if (!Objects.equals(this.structureNbt, structureNbt)){
            this.structureNbt = structureNbt;
            method_5431();
            updateBlockModel();
        }
    }

    public void setStructure(class_3499 structure) {
        setStructure(structure.method_15175(new class_2487()));
    }

    @Nullable
    public class_2487 getStructureNbt() {
        return structureNbt;
    }

    protected void updateBlockModel() {
        if (this.field_11863 == null)
            return;

        this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), class_2248.field_31030);
    }

    @Override
    public @Nullable Object getRenderAttachmentData() {
        return getStructureNbt();
    }

}
