package be.immersivechess.client;

import be.immersivechess.block.Blocks;
import be.immersivechess.block.entity.BlockEntityTypes;
import be.immersivechess.client.color.ColorProviders;
import be.immersivechess.client.gui.ChessCaseScreen;
import be.immersivechess.client.gui.ChessGameScreen;
import be.immersivechess.client.render.block.entity.BoardBlockEntityRenderer;
import be.immersivechess.client.render.block.entity.PieceStructureBlockEntityRenderer;
import be.immersivechess.client.render.model.ModelProvider;
import be.immersivechess.client.structure.StructureResolver;
import be.immersivechess.item.ChessCase;
import be.immersivechess.item.Items;
import be.immersivechess.item.PieceContainer;
import be.immersivechess.screen.ScreenHandlerTypes;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.model.ModelLoadingRegistry;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroupEntries;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3499;
import net.minecraft.class_3929;
import net.minecraft.class_5272;
import net.minecraft.class_5616;
import net.minecraft.class_7706;
import net.minecraft.class_7923;

@Environment(EnvType.CLIENT)
public class ImmersiveChessClient implements ClientModInitializer {

    @Override
    public void onInitializeClient() {
        // ModelProviders
        ModelLoadingRegistry.INSTANCE.registerResourceProvider(rm -> new ModelProvider());

        // Screens
        class_3929.method_17542(ScreenHandlerTypes.CHESS_CASE_SCREEN_HANDLER_TYPE, ChessCaseScreen::new);
        class_3929.method_17542(ScreenHandlerTypes.CHESS_GAME_SCREEN_HANDLER_TYPE, ChessGameScreen::new);

        // Support transparency in piece models and board blocks. Most of them use material
        // PieceStructureBlock is defined in json and needs cutout for icon overlay
        BlockRenderLayerMap.INSTANCE.putBlocks(class_1921.method_23581(), Blocks.PIECE_STRUCTURE_BLOCKS.toArray(new class_2248[0]));
        BlockRenderLayerMap.INSTANCE.putBlocks(class_1921.method_23581(), Blocks.BOARD_BLOCK);

        // BlockEntityRenderers
        class_5616.method_32144(BlockEntityTypes.PIECE_STRUCTURE_BLOCK_ENTITY_TYPE, PieceStructureBlockEntityRenderer::new);
        class_5616.method_32144(BlockEntityTypes.BOARD_BLOCK_ENTITY_TYPE, BoardBlockEntityRenderer::new);

        // Color providers
        ColorProviders.onInitializeClient();

        // Model predicate for opening chess case when interacted with
        class_5272.method_27879(Items.CHESS_CASE, new class_2960("open"), (itemStack, clientWorld, livingEntity, i) -> {
            if (livingEntity == null || itemStack == null)
                return 0f;
            if (itemStack.method_7909() instanceof ChessCase)
                return ChessCase.isOpen(itemStack) ? 1f : 0f;
            return 0f;
        });

        // Piece stands with default structure
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_41062).register(content -> {
            addPieceStands(content);
        });

        ItemGroupEvents.modifyEntriesEvent(class_7923.field_44687.method_29113(Items.IC_GROUP).get()).register(content -> {
            addPieceStands(content);
        });
    }

    private static void addPieceStands(FabricItemGroupEntries content){
        Items.PIECE_STANDS.values().forEach(pieceStandItem -> {
            class_1799 stand = new class_1799(pieceStandItem);
            class_3499 structure = StructureResolver.getDefaultStructure(pieceStandItem.getPiece());
            PieceContainer.writeStructureNbt(stand, structure.method_15175(new class_2487()));
            content.method_45420(stand);
        });
    }

}
