package be.immersivechess.client.color;

import be.immersivechess.block.Blocks;
import be.immersivechess.block.PieceStandBlock;
import be.immersivechess.block.entity.DyedStructureRenderedBlockEntity;
import be.immersivechess.item.Items;
import be.immersivechess.item.PieceContainer;
import be.immersivechess.item.PieceStandItem;
import be.immersivechess.item.StandItem;
import be.immersivechess.recipe.StandDyeRecipe;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.minecraft.class_1768;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_322;
import net.minecraft.class_326;
import org.jetbrains.annotations.Nullable;

public class ColorProviders {

    /**
     * Forwards colorProviders based on tintIndex mapping int TintMapper
     */
    private static class ForwardingColorProvider implements class_322, class_326{
        @Override
        public int getColor(class_2680 state, @Nullable class_1920 world, @Nullable class_2338 pos, int tintIndex) {
            class_322 colorProvider = TintMapper.INSTANCE.getBlockColorProvider(tintIndex);
            return colorProvider == null ? -1 : colorProvider.getColor(net.minecraft.class_2246.field_10124.method_9564(), world, pos, tintIndex % TintMapper.CAPACITY);
        }

        @Override
        public int getColor(class_1799 stack, int tintIndex) {
            // We only need to forward colors for blocks, not potions etc.
            return getColor(net.minecraft.class_2246.field_10124.method_9564(), null, null, tintIndex);
        }
    }

    private static class DyeColorProvider implements class_322, class_326{
        // create dummy to access non-static functions that could have been static.
        private static final class_1768 DYEABLE_ITEM = new class_1768(){};

        @Override
        public int getColor(class_2680 state, @Nullable class_1920 world, @Nullable class_2338 pos, int tintIndex) {
            if (tintIndex > 0 || world == null || pos == null)
                return -1;

            if (world.method_8321(pos) instanceof DyedStructureRenderedBlockEntity blockEntity)
                return blockEntity.getColor();

            return StandItem.DEFAULT_COLOR_INT;
        }

        @Override
        public int getColor(class_1799 stack, int tintIndex) {
            if (tintIndex > 0)
                return -1;

            return PieceContainer.getColor(stack);
        }
    }

    /**
     * Combines ForwardingColorProvider and DyeColorProvider based on tintIndex
     */
    private static class CombinedColorProvider implements class_322, class_326{
        private final DyeColorProvider dyeColorProvider;
        private final ForwardingColorProvider forwardingColorProvider;

        public CombinedColorProvider(DyeColorProvider dyeColorProvider, ForwardingColorProvider forwardingColorProvider){
            this.dyeColorProvider = dyeColorProvider;
            this.forwardingColorProvider = forwardingColorProvider;
        }

        @Override
        public int getColor(class_2680 state, @Nullable class_1920 world, @Nullable class_2338 pos, int tintIndex) {
            return tintIndex < TintMapper.CAPACITY ? dyeColorProvider.getColor(state, world, pos, tintIndex) : forwardingColorProvider.getColor(state, world, pos, tintIndex);
        }

        @Override
        public int getColor(class_1799 stack, int tintIndex) {
            return tintIndex < TintMapper.CAPACITY ? dyeColorProvider.getColor(stack, tintIndex) : forwardingColorProvider.getColor(stack, tintIndex);
        }
    }

    public static void onInitializeClient() {
        ForwardingColorProvider forwardingColorProvider = new ForwardingColorProvider();
        DyeColorProvider dyeColorProvider = new DyeColorProvider();
        CombinedColorProvider combinedColorProvider = new CombinedColorProvider(dyeColorProvider, forwardingColorProvider);

        // structure rendered blocks and items
        ColorProviderRegistry.BLOCK.register(forwardingColorProvider, Blocks.BOARD_BLOCK);
        ColorProviderRegistry.BLOCK.register(forwardingColorProvider, Blocks.PIECES.values().toArray(new class_2248[0]));
        ColorProviderRegistry.ITEM.register(forwardingColorProvider, Items.PIECE_ITEMS.values().toArray(new class_1792[0]));

        // stands that can be dyed in blocks and items
        ColorProviderRegistry.BLOCK.register(dyeColorProvider, Blocks.BLANK_STAND);
        ColorProviderRegistry.ITEM.register(dyeColorProvider, Items.BLANK_STAND);

        // blocks and items that can both be dyed and contain a structure
        ColorProviderRegistry.BLOCK.register(combinedColorProvider, Blocks.PIECE_STANDS.toArray(new class_2248[0]));
        ColorProviderRegistry.BLOCK.register(combinedColorProvider, Blocks.PIECE_STRUCTURE_BLOCKS.toArray(new class_2248[0]));
        ColorProviderRegistry.ITEM.register(combinedColorProvider, Items.PIECE_STANDS.values().toArray(new PieceStandItem[0]));
    }


}
