package be.immersivechess.client.data;

import be.immersivechess.ImmersiveChess;
import be.immersivechess.client.mixin.SpriteContentsAccess;
import be.immersivechess.logic.MultiblockBoard;
import be.immersivechess.resource.BlockStateLuminanceMapper;
import com.google.gson.JsonElement;
import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_1011;
import net.minecraft.class_1041;
import net.minecraft.class_1060;
import net.minecraft.class_1087;
import net.minecraft.class_1092;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2405;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_324;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3283;
import net.minecraft.class_3304;
import net.minecraft.class_3682;
import net.minecraft.class_3902;
import net.minecraft.class_4011;
import net.minecraft.class_543;
import net.minecraft.class_5819;
import net.minecraft.class_7403;
import net.minecraft.class_773;
import net.minecraft.class_7764;
import net.minecraft.class_777;
import net.minecraft.class_7784;
import net.minecraft.class_7923;
import net.minecraft.resource.*;
import java.util.List;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;

class BlockColorGenerator implements class_2405 {

    private final class_7784.class_7489 pathResolver;

    public BlockColorGenerator(FabricDataOutput dataOutput) {
        this.pathResolver = dataOutput.method_45973(class_7784.class_7490.field_39367, "chess");
    }

    @Override
    public String method_10321() {
        return "Chess Block Color";
    }

    @Override
    public CompletableFuture<?> method_10319(class_7403 writer) {
        BlockStateLuminanceMapper.BlockColorsJson data = getJsonBlockStates();

        JsonElement root = BlockStateLuminanceMapper.GSON.toJsonTree(data);

        return class_2405.method_10320(writer, root, pathResolver.method_44107(new class_2960(ImmersiveChess.MOD_ID, "block_colors")));
    }

    private BlockStateLuminanceMapper.BlockColorsJson getJsonBlockStates() {
        BlockStateLuminanceMapper.BlockColorsJson data = new BlockStateLuminanceMapper.BlockColorsJson();
        class_773 blockModels = loadBlockModels();

        for (class_2248 block : class_7923.field_41175) {
            for (class_2680 state : block.method_9595().method_11662()) {
                if (!MultiblockBoard.isBoardMaterial(state))
                    continue;
                OptionalDouble color = getPerceivedLuminanceOfBlockStateTop(state, blockModels);
                if (color.isEmpty()) {
                    ImmersiveChess.LOGGER.info("No color computed for " + state);
                    continue;
                }
                data.blockstates.put(state, color.getAsDouble());
            }
        }

        return data;
    }

    private static OptionalDouble getPerceivedLuminanceOfBlockStateTop(class_2680 state, class_773 blockModels) {
        class_5819 random = class_5819.method_43049(42);

        class_1087 model = blockModels.method_3335(state);
        if (model == null)
            return OptionalDouble.empty();

        List<class_777> quads = model.method_4707(state, class_2350.field_11036, random);
        return quads.stream().mapToDouble(BlockColorGenerator::averagePerceivedLuminance).average();
    }

    private static double averagePerceivedLuminance(class_777 quad) {
        // Color index depends on position in world.
        //  could take average of possible biome colors and use image.blend (see `BiomeColors`). Would only matter for grass
        //  or just ignore and continue with uncolored version which likely gives a good estimate.
//            quad.getColorIndex();

        class_7764 contents = quad.method_35788().method_45851();
        class_1011 image = ((SpriteContentsAccess) contents).getImage();
        return ImageHelper.averagePerceivedLuminance(image);
    }

    private class_773 loadBlockModels() {
        // Datagen is injected before models are loaded. The following code is copied from MinecraftClient to
        // load the models
        class_310 client = class_310.method_1551();

        RenderSystem.initBackendSystem();
        class_3682 windowProvider = new class_3682(client);
        class_543 windowSettings = new class_543(1, 1, OptionalInt.of(1), OptionalInt.of(1), false);
        class_1041 window = windowProvider.method_16038(windowSettings, null, "");

        class_3304 resourceManager = new class_3304(class_3264.field_14188);
        class_1060 textureManager = new class_1060(resourceManager);
        // somehow the reloader gets stuck on this one
//            resourceManager.registerReloader(textureManager);

        // probably optional
//            resourceManager.registerReloader(new GrassColormapResourceSupplier());
//            resourceManager.registerReloader(new FoliageColormapResourceSupplier());

        class_324 blockColors = class_324.method_1689();
        class_1092 bakedModelManager = new class_1092(textureManager, blockColors, 0);
        resourceManager.method_14477(bakedModelManager);

        class_3283 resourcePackManager = client.method_1520();
        resourcePackManager.method_14445();
        List<class_3262> list = resourcePackManager.method_29211();
        CompletableFuture<class_3902> COMPLETED_UNIT_FUTURE = CompletableFuture.completedFuture(class_3902.field_17274);

        // Use client executor rather than `Util.getMainWorkerExecutor()` (as in MinecraftClient) because it doesn't work
        class_4011 resourceReload = resourceManager.method_18232(client, client, COMPLETED_UNIT_FUTURE, list);
        resourceReload.method_18364().join();

        return bakedModelManager.method_4743();
    }

}
