package be.immersivechess.client.data.lang;

import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import java.io.IOException;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class ImputingLangProvider extends BaseLangProvider {
    protected ImputingLangProvider(FabricDataOutput dataOutput, String languageCode) {
        super(dataOutput, languageCode);
    }

    public static FabricDataGenerator.Pack.Factory<ImputingLangProvider> factory(String languageCode) {
        return output -> new ImputingLangProvider(output, languageCode);
    }

    @Override
    public void generateTranslations(TranslationBuilder translationBuilder) {
        try {
            translationBuilder.add(getStaticLangFilePath());
        } catch (IOException e) {
            throw new RuntimeException(e);
        }

        translationBuilder = getFillMissingTranslationBuilder(translationBuilder);

        // Fill in missing from registries
        addIfMissing(class_7923.field_41178, translationBuilder::add);
        addIfMissing(class_7923.field_41175, translationBuilder::add);
        addIfMissing(class_7923.field_41177, translationBuilder::add);
        addIfMissing(class_7923.field_41176, translationBuilder::add);
        addIfMissing(class_7923.field_41190, translationBuilder::add);
        addIfMissing(class_7923.field_41193, translationBuilder::add);
        addIfMissing(class_7923.field_41174, translationBuilder::add);

        // a lot of work because out of all registries, itemgroups are the only one that use keys iso the actual value
        // because it needs to be final apparently
        TranslationBuilder tb = translationBuilder;
        addIfMissing(class_7923.field_44687, (ig, val) -> tb.add(class_7923.field_44687.method_29113(ig).get(), val));
    }

    private <T> void addIfMissing(class_2378<T> registry, BiConsumer<T, String> consumer) {
        for (Map.Entry<? extends class_5321<T>, T> entry : registry.method_29722()) {
            if (withinNamespace(entry.getKey().method_29177())) {
                consumer.accept(entry.getValue(), entry.getKey().method_29177().method_12832());
            }
        }
    }

    private boolean withinNamespace(class_2960 id){
        return id.method_12836().equals(dataOutput.getModId());
    }
}
