package be.immersivechess.client.gui;

import be.immersivechess.ImmersiveChess;
import be.immersivechess.screen.ChessGameScreenHandler;
import be.immersivechess.world.PieceRenderOption;
import ch.astorm.jchess.core.Color;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.DataFixUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_465;
import net.minecraft.class_5676;
import net.minecraft.class_7919;

@Environment(EnvType.CLIENT)
public class ChessGameScreen extends class_465<ChessGameScreenHandler> {

    private static final class_2960 TEXTURE = new class_2960(ImmersiveChess.MOD_ID, "textures/gui/chess_game.png");
    private static final int BUTTON_WIDTH = 110;
    private static final int BUTTON_HEIGHT = 20;
    private static final int BUTTON_PADDING = 8;

    private final class_4185 drawButton = class_4185.method_46430(class_2561.method_43471("immersivechess.offer_draw").method_27694(s -> s.method_10977(class_124.field_1054)), createButtonAction(ChessGameScreenHandler.Button.DRAW))
            .method_46437(BUTTON_WIDTH, BUTTON_HEIGHT).method_46431();

    private final class_4185 resignButton = class_4185.method_46430(class_2561.method_43471("immersivechess.resign").method_27694(s -> s.method_10977(class_124.field_1054)), createButtonAction(ChessGameScreenHandler.Button.RESIGN))
            .method_46437(BUTTON_WIDTH, BUTTON_HEIGHT).method_46431();

    private final class_4185 endButton = class_4185.method_46430(class_2561.method_43471("immersivechess.clear_board").method_27694(s -> s.method_10977(class_124.field_1061)), createButtonAction(ChessGameScreenHandler.Button.STOP_BOARD))
            .method_46437(BUTTON_WIDTH, BUTTON_HEIGHT)
            .method_46436(class_7919.method_47407(class_2561.method_43471("immersivechess.clear_board.tooltip")))
            .method_46431();

    private final class_4185 closeButton = class_4185.method_46430(class_2561.method_43471("menu.returnToGame"), b -> method_25419())
            .method_46437(BUTTON_WIDTH, BUTTON_HEIGHT)
            .method_46431();

    private final class_5676<PieceRenderOption> whitePieceButton;
    private final class_5676<PieceRenderOption> blackPieceButton;

    public ChessGameScreen(ChessGameScreenHandler handler, class_1661 inventory, class_2561 title) {
        super(handler, inventory, title);
        this.field_2792 = 245;

        whitePieceButton = class_5676.method_32606(PieceRenderOption::getText)
                .method_32620(handler.getWhiteRenderOptions())
                .method_32619(handler.getInitialWhiteRenderOption())
                .method_32618(option -> class_7919.method_47407(class_2561.method_43471("immersivechess.white_piece_render_option_button.tooltip")))
                .method_32617(0, 0, BUTTON_WIDTH, BUTTON_HEIGHT, class_2561.method_43471("immersivechess.piece_render_option_button"), createPieceRenderOptionAction(Color.WHITE));

        blackPieceButton = class_5676.method_32606(PieceRenderOption::getText)
                .method_32620(handler.getBlackRenderOptions())
                .method_32619(handler.getInitialBlackRenderOption())
                .method_32618(option -> class_7919.method_47407(class_2561.method_43471("immersivechess.black_piece_render_option_button.tooltip")))
                .method_32617(0, 0, BUTTON_WIDTH, BUTTON_HEIGHT, class_2561.method_43471("immersivechess.piece_render_option_button"), createPieceRenderOptionAction(Color.BLACK));
    }

    @Override
    protected void method_25426() {
        super.method_25426();

        if (field_22787 == null || field_22787.field_1724 == null) return;
        class_1657 player = field_22787.field_1724;

        int leftX = field_2776 + field_2792 / 4 - BUTTON_WIDTH / 2;
        int rightX = field_2776 + 3 * field_2792 / 4 - BUTTON_WIDTH / 2;

        int buttonY = field_2800 + 55;
        int buttonDist = BUTTON_HEIGHT + BUTTON_PADDING;

        // render options: only if current player or OP
        if (player.method_7338() || player.method_5820().equals(field_2797.getWhite()) || player.method_5820().equals(field_2797.getBlack())){
            if (!field_2797.getWhite().isEmpty())
                method_37063(DataFixUtils.make(whitePieceButton, b -> b.method_48229(leftX, buttonY)));
            if (!field_2797.getBlack().isEmpty())
                method_37063(DataFixUtils.make(blackPieceButton, b -> b.method_48229(rightX, buttonY)));
        }

        // game controls: only when game valid and not finished
        if (!field_2797.getStatus().isFinished() && field_2797.getWhite().length() != 0 && field_2797.getBlack().length() != 0) {
            // only for players of the game
            if (player.method_5820().equals(field_2797.getWhite()) || player.method_5820().equals(field_2797.getBlack())) {

                // set buttons on correct side
                Color playerColor = player.method_5820().equals(field_2797.getWhite()) ? Color.WHITE : Color.BLACK;
                int resignX = switch(playerColor) {case WHITE -> leftX; case BLACK -> rightX;};
                int drawX = switch(playerColor) {case WHITE -> rightX; case BLACK -> leftX;};

                if (player.method_5820().equals(field_2797.getDrawOfferedTo())) {
                    drawButton.method_25355(class_2561.method_43471("immersivechess.accept_draw").method_27694(s -> s.method_10977(class_124.field_1054)));
                    drawButton.method_47400(class_7919.method_47407(class_2561.method_43471("immersivechess.accept_draw.tooltip")));
                }

                method_37063(DataFixUtils.make(drawButton, b -> b.method_48229(drawX, buttonY + buttonDist)));
                method_37063(DataFixUtils.make(resignButton, b -> b.method_48229(resignX, buttonY + buttonDist)));
            }
        }

        // cleanup board: only when game finished, not started or for OP
        if (field_2797.getStatus().isFinished() || player.method_7338() || field_2797.getMoveCount() == 1)
            method_37063(DataFixUtils.make(endButton, b -> b.method_48229(leftX, buttonY + 3 * buttonDist)));

        // back to game button
        method_37063(DataFixUtils.make(closeButton, b -> b.method_48229(rightX, buttonY + 3 * buttonDist)));
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        // grays out world
        this.method_25420(context, mouseX, mouseY, delta);
        super.method_25394(context, mouseX, mouseY, delta);
        super.method_2380(context, mouseX, mouseY);
    }

    @Override
    protected void method_2388(class_332 context, int mouseX, int mouseY) {
        // player names
        int nameY = field_25268 + 16;
        int whiteX = (int)(field_2792 / 4f - field_22793.method_1727(field_2797.getWhite()) / 2f);
        int blackX = (int)(3 * field_2792 / 4f - field_22793.method_1727(field_2797.getBlack()) / 2f);
        context.method_51433(field_22793, field_2797.getWhite(), whiteX, nameY, 0xFFFFFF, false);
        context.method_51433(field_22793, field_2797.getBlack(), blackX, nameY, 0x000000, false);

        // move counter
        int moveY = nameY + 16;
        String moveCountText = Integer.toString((int) Math.ceil(field_2797.getMoveCount() / 2d));
        int moveCountWidth = field_22793.method_1727(moveCountText);
        int moveX = (int)(field_2792 / 2f - moveCountWidth / 2f);
        context.method_51433(field_22793, moveCountText, moveX, moveY, 0x404040, false);

//        RenderSystem.setShader(GameRenderer::getPositionTexProgram);
//        RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
//        RenderSystem.setShaderTexture(0, TEXTURE);

        // turn and game outcome
        switch (field_2797.getStatus()) {
            case NOT_FINISHED -> {
                // turn
                switch (field_2797.getTurn()) {
                    case WHITE -> context.method_25302(TEXTURE, moveX - 7, moveY + 1, 0, field_2779, 4, 6);
                    case BLACK ->
                            context.method_25302(TEXTURE, moveX + 3 + moveCountWidth, moveY + 1, 4, field_2779, 4, 6);
                }
            }
            // winner
            case WIN_WHITE ->
                    context.method_25302(TEXTURE, field_2792 / 4 - 5, nameY - 9, 8, field_2779, 11, 5);
            case WIN_BLACK ->
                    context.method_25302(TEXTURE, 3 * field_2792 / 4 - 5, nameY - 9, 8, field_2779, 11, 5);
            // draw
            case DRAW, DRAW_STALEMATE, DRAW_REPETITION, DRAW_NOCAPTURE -> {
                context.method_25302(TEXTURE, field_2792 / 4 - 5, nameY - 9, 19, field_2779, 11, 5);
                context.method_25302(TEXTURE, 3 * field_2792 / 4 - 5, nameY - 9, 19, field_2779, 11, 5);
            }
        }
    }

    @Override
    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
//        RenderSystem.setShader(GameRenderer::getPositionTexProgram);
//        RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
//        RenderSystem.setShaderTexture(0, TEXTURE);
        context.method_25302(TEXTURE, field_2776, field_2800, 0, 0, field_2792, field_2779);
    }

    private class_4185.class_4241 createButtonAction(ChessGameScreenHandler.Button buttonType) {
        return button -> {
            this.sendButtonPressPacket(buttonType.ordinal());
            method_25419();
        };
    }

    private class_5676.class_5678<PieceRenderOption> createPieceRenderOptionAction(Color color) {
        return (button, value) -> {
            this.sendButtonPressPacket(ChessGameScreenHandler.Button.getRenderOptionButton(color, value).ordinal());
        };
    }

    private void sendButtonPressPacket(int id) {
        if (field_22787 == null || field_22787.field_1761 == null) return;
        this.field_22787.field_1761.method_2900(this.field_2797.field_7763, id);
    }

}
