package be.immersivechess.client.render.block.entity;

import be.immersivechess.ImmersiveChess;
import be.immersivechess.block.entity.BoardBlockEntity;
import be.immersivechess.item.PieceContainer;
import be.immersivechess.item.PieceItem;
import be.immersivechess.logic.Piece;
import be.immersivechess.recipe.StandDyeRecipe;
import ch.astorm.jchess.core.Color;
import net.minecraft.class_1723;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4730;
import net.minecraft.class_5253;
import net.minecraft.class_5614;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import net.minecraft.client.render.*;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class BoardBlockEntityRenderer implements class_827<BoardBlockEntity> {

    private final class_5614.class_5615 context;

    private static final class_4730 SQUARE_SPRITE_ID = new class_4730(class_1723.field_21668, new class_2960(ImmersiveChess.MOD_ID, "block/highlight_square"));
    private static final class_4730 ATTACK_SPRITE_ID = new class_4730(class_1723.field_21668, new class_2960(ImmersiveChess.MOD_ID, "block/highlight_attack"));
    private static final class_4730 DOT_SPRITE_ID = new class_4730(class_1723.field_21668, new class_2960(ImmersiveChess.MOD_ID, "block/highlight_dot"));

    private static final int WHITE_COLOR = class_5253.class_5254.method_27764(255, 255, 255, 255);
    private static final int RED_COLOR = StandDyeRecipe.dyeColorToColor(class_1767.field_7964);

    public BoardBlockEntityRenderer(class_5614.class_5615 context) {
        this.context = context;
    }

    @Override
    public int method_33893() {
        return class_827.super.method_33893();
    }

    @Override
    public void render(BoardBlockEntity entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
//        if (entity.getSquare() != null)
//            renderSquare(entity, matrices, vertexConsumers, light);

        if (shouldHighlightDestinations(entity))
            renderPossiblePositionHighlight(entity, matrices, vertexConsumers, light);

        Piece piece = entity.getPiece();
        if (piece != null)
            renderOriginHighlight(entity, matrices, vertexConsumers, light, piece);

        if (entity.isInCheck())
            renderKingUnderAttackHighlight(entity, matrices, vertexConsumers, light);
    }

    /**
     * Render square coordinate above block. Mostly for debugging
     */
    public void renderSquare(BoardBlockEntity entity, class_4587 matrices, class_4597 vertexConsumers, int light) {
        String text = entity.getSquare().toString();
        matrices.method_22903();
        float scale = 0.07f;
        int color = 0xFFFFFF;
        light = class_765.field_32767;

        matrices.method_22904(0.1, 1.001, 0.2);
        matrices.method_22907(class_7833.field_40714.rotationDegrees(90));
        matrices.method_22905(scale, scale, scale);
        context.method_32143().method_27521(text, 0, 0, color, false, matrices.method_23760().method_23761(), vertexConsumers, class_327.class_6415.field_33993, 0, light);
        matrices.method_22909();
    }

    /**
     * Returns the held itemstack by the player if it belongs to this game. Null otherwise.
     */
    private class_1799 getPlayerHoldingIfPieceOfGame(BoardBlockEntity entity) {
        if (class_310.method_1551().field_1724 == null) return null;

        class_1799 playerHolding = class_310.method_1551().field_1724.method_6047();
        if (!(playerHolding.method_7909() instanceof PieceItem)) return null;

        String gameId = PieceContainer.getGameSaveId(playerHolding);
        if (gameId == null || !gameId.equals(entity.getGameSaveId())) return null;

        return playerHolding;
    }

    private boolean shouldHighlightDestinations(BoardBlockEntity entity) {
        class_1799 playerHolding = getPlayerHoldingIfPieceOfGame(entity);
        if (playerHolding == null) return false;

        return PieceContainer.getDestinationSquares(playerHolding).contains(entity.getSquare());
    }

    public void renderPossiblePositionHighlight(BoardBlockEntity entity, class_4587 matrices, class_4597 vertexConsumers, int light) {
        class_4588 consumer = SQUARE_SPRITE_ID.method_24145(vertexConsumers, class_1921::method_23576);

        // determine color of piece
        class_1799 playerHolding = class_310.method_1551().field_1724.method_6047();
        if (!(playerHolding.method_7909() instanceof PieceContainer pieceContainer))
            return;

        matrices.method_22903();
        matrices.method_46416(0, 1, 0);
        Matrix4f positionMatrix = matrices.method_23760().method_23761();
        Matrix3f normalMatrix = matrices.method_23760().method_23762();

        // can have color depend on type, but black is not always visible.
        renderSquare(positionMatrix, normalMatrix, consumer, 0, 0.001f, 0, 0, 0, WHITE_COLOR);

        matrices.method_22909();
    }

    public void renderOriginHighlight(BoardBlockEntity entity, class_4587 matrices, class_4597 vertexConsumers, int light, Piece piece) {
        class_2960 iconIdentifier = piece.getIdentifier().method_45138("item/icon/");
        class_4730 spriteId = new class_4730(class_1723.field_21668, iconIdentifier);
        class_4588 consumer = spriteId.method_24145(vertexConsumers, class_1921::method_23576);

        class_2350 facing = entity.getWhitePlayDirection();
        if (piece.getColor().equals(Color.BLACK))
            facing = facing.method_10153();

        matrices.method_22903();
        matrices.method_22904(0.5, 1, 0.5);
        matrices.method_22907(class_7833.field_40715.rotationDegrees(180 + facing.method_10144()));
        matrices.method_22904(-0.5, 0, -0.5);

        Matrix4f positionMatrix = matrices.method_23760().method_23761();
        Matrix3f normalMatrix = matrices.method_23760().method_23762();
        renderSquare(positionMatrix, normalMatrix, consumer, 0, 0.001f, 0, 0, 0);
        matrices.method_22909();
    }

    public void renderKingUnderAttackHighlight(BoardBlockEntity entity, class_4587 matrices, class_4597 vertexConsumers, int light) {
        class_4588 consumer = ATTACK_SPRITE_ID.method_24145(vertexConsumers, class_1921::method_23576);

        matrices.method_22903();
        matrices.method_46416(0, 1, 0);
        Matrix4f positionMatrix = matrices.method_23760().method_23761();
        Matrix3f normalMatrix = matrices.method_23760().method_23762();

        renderSquare(positionMatrix, normalMatrix, consumer, 0, 0.001f, 0, 0, 0, RED_COLOR);

        matrices.method_22909();
    }

    private static void renderSquare(Matrix4f positionMatrix, Matrix3f normalMatrix, class_4588 consumer, float x, float y, float z, float u, float v) {
        renderSquare(positionMatrix, normalMatrix, consumer, x, y, z, u, v, class_5253.class_5254.method_27764(255, 255, 255, 255));
    }

    private static void renderSquare(Matrix4f positionMatrix, Matrix3f normalMatrix, class_4588 consumer, float x, float y, float z, float u, float v, int color) {
        float uv_offset = 1f;
        vertex(positionMatrix, normalMatrix, consumer, x, y, z, u, v, color);
        vertex(positionMatrix, normalMatrix, consumer, x, y, z + 1, u, v + uv_offset, color);
        vertex(positionMatrix, normalMatrix, consumer, x + 1, y, z + 1, u + uv_offset, v + uv_offset, color);
        vertex(positionMatrix, normalMatrix, consumer, x + 1, y, z, u + uv_offset, v, color);
    }

    /**
     * @param v the top-most coordinate of the texture region
     * @param u the left-most coordinate of the texture region
     */
    private static void vertex(Matrix4f positionMatrix, Matrix3f normalMatrix, class_4588 consumer, float x, float y, float z, float u, float v, int color) {
        // Note: chaining these operations together turns the VertexConsumer from a SpriteTexturedVertexConsumer into another one.
        consumer.method_22918(positionMatrix, x, y, z);
        consumer.method_39415(color);
        consumer.method_22913(u, v);
        consumer.method_22922(class_4608.field_21444);
        consumer.method_22916(class_765.field_32767);
        consumer.method_23763(normalMatrix, 0.0f, 1.0f, 0.0f);
        consumer.method_1344();
    }

}
