package be.immersivechess.client.render.block.entity;

import be.immersivechess.block.PieceStructureBlock;
import be.immersivechess.block.entity.PieceStructureBlockEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_238;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_761;
import net.minecraft.class_827;
import org.joml.Quaternionf;

@Environment(EnvType.CLIENT)
public class PieceStructureBlockEntityRenderer implements class_827<PieceStructureBlockEntity> {

    private final class_5614.class_5615 context;

    public PieceStructureBlockEntityRenderer(class_5614.class_5615 context){
        this.context = context;
    }

    @Override
    public void render(PieceStructureBlockEntity entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        if (entity.shouldShowOutline())
            renderOutline(entity, matrices, vertexConsumers);
    }

    public void renderOutline(PieceStructureBlockEntity entity, class_4587 matrices, class_4597 vertexConsumers){
        float outlineColorUniform = switch(entity.getPiece().getColor()){
            case BLACK -> 0f;
            case WHITE -> 1f;
        };

        class_238 box = new class_238(0, 0, 0, PieceStructureBlock.PIECE_BASE_SIZE, entity.getPieceHeight(), PieceStructureBlock.PIECE_BASE_SIZE);

        class_4588 vertexConsumer = vertexConsumers.getBuffer(class_1921.method_23594());
        float rotation = -(float)Math.toRadians(entity.getFacing().method_10144());

        matrices.method_22903();
        // rotation
        matrices.method_22904(0.5, 0.5, 0.5);
        matrices.method_22907(new Quaternionf().rotationY(rotation));
        matrices.method_22904(-0.5, -0.5, -0.5);
        // translation
        matrices.method_46416(0, 0, 1);
        class_761.method_22982(matrices, vertexConsumer, box, outlineColorUniform, outlineColorUniform, outlineColorUniform, 1.0f);
        matrices.method_22909();
    }

    @Override
    public boolean rendersOutsideBoundingBox(PieceStructureBlockEntity blockEntity) {
        return true;
    }

    @Override
    public int method_33893() {
        return 32;
    }
}
