package be.immersivechess.client.render.model;

import be.immersivechess.ImmersiveChess;
import be.immersivechess.block.Blocks;
import be.immersivechess.client.color.TintMapper;
import ch.astorm.jchess.core.Color;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.fabricmc.fabric.api.renderer.v1.material.MaterialFinder;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.MeshBuilder;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.model.ModelHelper;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachedBlockView;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1100;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3665;
import net.minecraft.class_4730;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_7775;
import net.minecraft.class_806;
import net.minecraft.class_809;
import net.minecraft.client.render.model.*;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;

@Environment(EnvType.CLIENT)
public class BoardBlockModel implements class_1100 {

    private static final Map<Color, class_4730> spriteIdentifiers = Map.of(
            Color.BLACK, new class_4730(class_1723.field_21668, new class_2960(ImmersiveChess.MOD_ID, "block/board_black")),
            Color.WHITE, new class_4730(class_1723.field_21668, new class_2960(ImmersiveChess.MOD_ID, "block/board_white"))
    );

    private final Color color;

    public BoardBlockModel(Color color) {
        this.color = color;
    }

    @Override
    public Collection<class_2960> method_4755() {
        return Collections.emptyList();
    }

    @Override
    public void method_45785(Function<class_2960, class_1100> modelLoader) {

    }

    @Nullable
    @Override
    public class_1087 method_4753(class_7775 baker, Function<class_4730, class_1058> textureGetter, class_3665 rotationContainer, class_2960 modelId) {
        class_1058 sprite = textureGetter.apply(spriteIdentifiers.get(color));

        Renderer renderer = RendererAccess.INSTANCE.getRenderer();
        MeshBuilder builder = renderer.meshBuilder();
        QuadEmitter emitter = builder.getEmitter();

        for (class_2350 direction : class_2350.values()) {
            emitter.square(direction, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f);
            emitter.spriteBake(sprite, MutableQuadView.BAKE_LOCK_UV);
            emitter.color(-1, -1, -1, -1);
            emitter.emit();
        }

        Mesh defaultMesh = builder.build();

        return new BoardBlockBakedModel(sprite, defaultMesh);
    }

    static class BoardBlockBakedModel implements class_1087, FabricBakedModel {
        private final class_1058 particles;

        private final Mesh defaultMesh;

        private BoardBlockBakedModel(class_1058 particles, Mesh defaultMesh) {
            this.particles = particles;
            this.defaultMesh = defaultMesh;
        }

        @Override
        public boolean isVanillaAdapter() {
            return false;
        }

        private void emitAppearanceState(class_2680 appearanceState, QuadEmitter emitter, class_5819 random) {
            MaterialFinder materialFinder = RendererAccess.INSTANCE.getRenderer().materialFinder();
            materialFinder.blendMode(appearanceState.method_26225() ? BlendMode.SOLID : BlendMode.TRANSLUCENT);
            RenderMaterial material = materialFinder.find();
            class_1087 model = class_310.method_1551().method_1541().method_3349(appearanceState);

            for (class_2350 direction : Stream.concat(Arrays.stream(class_2350.values()), Stream.of((class_2350) null)).toList()) {

                for (class_777 quad : model.method_4707(appearanceState, direction, random)) {
                    emitter.fromVanilla(quad, material, direction);

                    // remap tintIndex to distinguish ColorProviders
                    int tintIndex = emitter.colorIndex();
                    if (tintIndex > -1) {
                        // we do not expect the tintIndex to exceed our allocated capacity.
                        if (tintIndex > TintMapper.CAPACITY)
                            ImmersiveChess.LOGGER.warn("tintIndex exceeds allocated capacity. Some colors may get translated wrong.");

                        int offset = TintMapper.INSTANCE.getTintOffset(appearanceState.method_26204());
                        emitter.colorIndex(offset + tintIndex);
                    }
                    emitter.emit();
                }
            }
        }

        @Override
        public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
//            ImmersiveChess.LOGGER.info("emitting block Quads");
            class_2680 appearanceState = getAppearanceBlockState(blockView, pos);
            if (appearanceState == null || appearanceState.method_26204() == Blocks.BOARD_BLOCK) {
                context.meshConsumer().accept(defaultMesh);
                return;
            }

            emitAppearanceState(appearanceState, context.getEmitter(), randomSupplier.get());
        }

        private @Nullable class_2680 getAppearanceBlockState(class_1920 blockView, class_2338 blockPos) {
            Object entityData = ((RenderAttachedBlockView) blockView).getBlockEntityRenderAttachment(blockPos);
            if (entityData instanceof class_2680 appearanceBlockState) {
                return appearanceBlockState;
            }
            return null;
        }

        @Override
        public void emitItemQuads(class_1799 stack, Supplier<class_5819> randomSupplier, RenderContext context) {
            context.meshConsumer().accept(defaultMesh);
        }

        @Override
        public List<class_777> method_4707(@Nullable class_2680 state, @Nullable class_2350 face, class_5819 random) {
            return Collections.emptyList();
        }

        @Override
        public boolean method_4708() {
            // TODO: should depend on material, but would have to make different types of board blocks..
            return false;
        }

        @Override
        public boolean method_4712() {
            return true;
        }

        @Override
        public boolean method_24304() {
            return true;
        }

        @Override
        public boolean method_4713() {
            return false;
        }

        @Override
        public class_1058 method_4711() {
            return particles;
        }

        @Override
        public class_809 method_4709() {
            return ModelHelper.MODEL_TRANSFORM_BLOCK;
        }

        @Override
        public class_806 method_4710() {
            return class_806.field_4292;
        }

    }
}
