package be.immersivechess.client.render.model;

import be.immersivechess.ImmersiveChess;
import be.immersivechess.client.structure.StructureResolver;
import be.immersivechess.logic.Piece;
import be.immersivechess.structure.StructureHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.MapMaker;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.MeshBuilder;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachedBlockView;
import net.fabricmc.fabric.impl.client.indigo.renderer.aocalc.VanillaAoHelper;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1100;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3499;
import net.minecraft.class_3568;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3665;
import net.minecraft.class_4590;
import net.minecraft.class_4730;
import net.minecraft.class_5819;
import net.minecraft.class_6539;
import net.minecraft.class_773;
import net.minecraft.class_777;
import net.minecraft.class_7775;
import net.minecraft.class_806;
import net.minecraft.class_809;
import net.minecraft.client.render.model.*;
import net.minecraft.util.math.*;
import net.minecraft.world.*;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

import java.util.*;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;

@Environment(EnvType.CLIENT)
public class PieceModel implements class_1100 {

    private final Piece piece;

    private final class_4730 spriteIdentifier = new class_4730(class_1723.field_21668, new class_2960("minecraft:block/stone"));

    public PieceModel(Piece piece) {
        this.piece = piece;
    }

    @Override
    public Collection<class_2960> method_4755() {
        // This model technically depends on all other models, but we only build the mesh at a later stage so this can be empty.
        return Collections.emptyList();
    }

    @Override
    public void method_45785(Function<class_2960, class_1100> modelLoader) {
    }

    @Nullable
    @Override
    public class_1087 method_4753(class_7775 baker, Function<class_4730, class_1058> textureGetter, class_3665 rotationContainer, class_2960 modelId) {
        class_1058 sprite = textureGetter.apply(spriteIdentifier);

        return new BakedPieceModel(piece, sprite, rotationContainer);
    }

    static class BakedPieceModel implements class_1087, FabricBakedModel {
        private final Piece piece;
        private final class_1058 particles;
        private final class_3665 rotationContainer;
        private static final boolean CULL = true;
        private static final float SCALE = 1f / 8f;

        private final class_809 modelTransformation;

        private final Map<class_3499, Mesh> meshCache = new MapMaker().weakKeys().makeMap();

        private BakedPieceModel(Piece piece, class_1058 particles, class_3665 rotationContainer) {
            this.piece = piece;
            this.particles = particles;
            this.rotationContainer = rotationContainer;
            modelTransformation = createModelTransformation();
        }

        private class_809 createModelTransformation() {
            class_809 modelTransformation = TransformationHelper.getMutableDefaultModelTransform();

            modelTransformation.field_4302.field_4287.y -= 225;
            modelTransformation.field_4304.field_4287.y -= 45;

            modelTransformation.field_4305.field_4287.y -= 45;
            modelTransformation.field_4307.field_4287.y -= 45;

            modelTransformation.field_4306.field_4286.y -= 0.2;
            modelTransformation.field_4306.field_4286.z -= 0.1;

            modelTransformation.field_4300.field_4285.mul(0.67f);
            modelTransformation.field_4300.field_4286.y -= 0.15;

            // Knights are rotated to the right in itemframe
            if (piece == Piece.WHITE_KNIGHT || piece == Piece.BLACK_KNIGHT) {
                modelTransformation.field_4306.field_4287.y += 90;
            }

            return modelTransformation;
        }

        @Override
        public List<class_777> method_4707(@Nullable class_2680 state, @Nullable class_2350 face, class_5819 random) {
            return Collections.emptyList();
        }

        @Override
        public boolean method_4708() {
            return true;
        }

        @Override
        public boolean method_4713() {
            return false;
        }

        @Override
        public boolean method_4712() {
            return true;
        }

        @Override
        public boolean method_24304() {
            return true;
        }

        @Override
        public class_1058 method_4711() {
            return particles;
        }

        @Override
        public class_809 method_4709() {
            return modelTransformation;
        }

        @Override
        public class_806 method_4710() {
            return class_806.field_4292;
        }

        @Override
        public boolean isVanillaAdapter() {
            return false;
        }

        @Override
        public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 blockPos, Supplier<class_5819> randomSupplier, RenderContext renderContext) {
            class_3499 structure = getStructure(blockView, blockPos);

            if (structure == null)
                return;

            Mesh mesh = getOrCreateMesh(structure, blockView, randomSupplier);
            renderContext.meshConsumer().accept(mesh);
        }

        @Override
        public void emitItemQuads(class_1799 stack, Supplier<class_5819> randomSupplier, RenderContext renderContext) {
            class_3499 structure = getStructure(stack);

            if (structure == null)
                return;

            Mesh mesh = getOrCreateMesh(structure, class_310.method_1551().field_1687, randomSupplier);
            renderContext.meshConsumer().accept(mesh);
        }

        @Nullable
        private class_3499 getStructure(class_1920 blockView, class_2338 blockPos) {
            // Nbt of structure is passed
            Object entityData = ((RenderAttachedBlockView) blockView).getBlockEntityRenderAttachment(blockPos);

            // null or unknown type -> return null which is empty structure
            if (!(entityData instanceof class_2487 structureNbt))
                return null;

            // empty nbt is also rendered as empty
            if (structureNbt.method_33133())
                return null;

            return StructureResolver.getStructure(structureNbt);
        }

        private class_3499 getStructure(class_1799 itemStack) {
            return StructureResolver.getStructure(itemStack);
        }

        private Mesh getOrCreateMesh(class_3499 structure, class_1920 worldBlockView, Supplier<class_5819> randomSupplier) {
            return meshCache.computeIfAbsent(structure, nbt -> createMesh(nbt, worldBlockView, randomSupplier));
        }

        private Mesh createMesh(class_3499 structure, class_1920 worldBlockView, Supplier<class_5819> randomSupplier) {
//            ImmersiveChess.LOGGER.info("creating new mesh for piece " + piece);
//            ImmersiveChess.LOGGER.info("cache size " + meshCache.size());

            net.minecraft.class_5819 random = randomSupplier.get();
            RenderMaterial material = RendererAccess.INSTANCE.getRenderer().materialFinder().blendMode(BlendMode.TRANSLUCENT).find();
            class_773 blockModels = class_310.method_1551().method_1554().method_4743();

            class_4590 affineTransformation = rotationContainer.method_3509();
            QuadTransform rotationTransform = new QuadTransform.Rotate(affineTransformation.method_22937());
            QuadTransform scaleTransform = new QuadTransform.Scale(SCALE);

            Map<class_2338, class_2680> blockStates = StructureHelper.buildBlockStateMap(structure);
            class_1920 world = createBlockRenderView(worldBlockView, blockStates);
            Renderer renderer = RendererAccess.INSTANCE.getRenderer();
            MeshBuilder builder = renderer.meshBuilder();
            QuadEmitter emitter = builder.getEmitter();

            for (Map.Entry<class_2338, class_2680> entry : blockStates.entrySet()) {
                class_2338 pos = entry.getKey();
                class_2680 bs = entry.getValue();

                QuadTransform translateTransform = new QuadTransform.Translate(pos.method_10263(), pos.method_10264(), pos.method_10260());
                QuadTransform tintTransform = new QuadTransform.TintRemap(bs);

                for (class_2350 direction : Stream.concat(Arrays.stream(class_2350.values()), Stream.of((class_2350) null)).toList()) {
                    // update to blockState appearances, which may differ from actual block states (facades etc.)
                    bs = bs.getAppearance(world, pos, direction, bs, null);
                    class_1087 model = blockModels.method_3335(bs);

                    if (direction != null) {
                        // culling is possible
                        class_2338 neighbourPos = pos.method_10093(direction);
                        if (CULL && !class_2248.method_9607(bs, world, pos, direction, neighbourPos)) continue;
                    }

                    for (class_777 quad : model.method_4707(bs, direction, random)) {
                        emitter.fromVanilla(quad, material, null);       //  set cullFace to null because quads are not guaranteed to be on a face (not full block)

                        translateTransform.transform(emitter);
                        scaleTransform.transform(emitter);
                        rotationTransform.transform(emitter);
                        tintTransform.transform(emitter);

                        emitter.emit();
                    }
                }
            }
            return builder.build();
        }

        private class_1920 createBlockRenderView(class_1920 worldBlockView, Map<class_2338, class_2680> blockStates) {
            return new class_1920() {

                @Override
                public float method_24852(class_2350 direction, boolean shaded) {
                    // This function is probably not called, but the return value makes sense at least.
                    return worldBlockView.method_24852(direction, shaded);
                }

                @Override
                public class_3568 method_22336() {
                    return null;
                }

                @Override
                public int method_23752(class_2338 pos, class_6539 colorResolver) {
                    // This function is never called, we return something sensible just in case.
                    ImmersiveChess.LOGGER.debug("got unexpected call to getColor. Likely wrong value was returned");
                    return worldBlockView.method_23752(pos, colorResolver);
                }

                @Override
                public int method_31605() {
                    return 16;
                }

                @Override
                public int method_31607() {
                    return 0;
                }

                @Nullable
                @Override
                public class_2586 method_8321(class_2338 pos) {
                    return null;
                }

                @Override
                public class_2680 method_8320(class_2338 pos) {
                    return blockStates.getOrDefault(pos, class_2246.field_10243.method_9564());
                }

                @Override
                public class_3610 method_8316(class_2338 pos) {
                    return class_3612.field_15906.method_15785();
                }
            };
        }

    }
}
