package be.immersivechess.client.render.model;

import be.immersivechess.ImmersiveChess;
import be.immersivechess.logic.Piece;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1100;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_4730;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_7775;
import net.minecraft.class_806;
import net.minecraft.class_809;
import net.minecraft.client.render.model.*;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

/**
 * Piece with stand below. Used for placeholders that go in chess case and during building of pieces with piece structure block.
 */
@Environment(EnvType.CLIENT)
public class PieceStandModel implements class_1100 {

    private final Piece piece;

    public PieceStandModel(Piece piece){
        this.piece = piece;
    }

    private class_2960 getPieceModelPath(){
        return new class_2960(ImmersiveChess.MOD_ID, "block/piece/" + piece.getIdentifier().method_12832());
    }

    private class_2960 getStandModelPath(){
        return new class_2960(ImmersiveChess.MOD_ID, "block/stand");
    }

    @Override
    public Collection<class_2960> method_4755() {
        return List.of(getPieceModelPath(), getStandModelPath());
    }

    @Override
    public void method_45785(Function<class_2960, class_1100> modelLoader) {
        modelLoader.apply(getStandModelPath());
        modelLoader.apply(getPieceModelPath());
    }

    @Nullable
    @Override
    public class_1087 method_4753(class_7775 baker, Function<class_4730, class_1058> textureGetter, class_3665 rotationContainer, class_2960 modelId) {
        class_1087 pieceModel = baker.method_45873(getPieceModelPath(), rotationContainer);
        class_1087 standModel = baker.method_45873(getStandModelPath(), rotationContainer);
        return new BakedPieceStandModel(piece, pieceModel, standModel);
    }

    static class BakedPieceStandModel implements class_1087, FabricBakedModel {
        private final Piece piece;
        private final class_1087 pieceModel;
        private final class_1087 standModel;

        private final class_809 modelTransformation;

        private BakedPieceStandModel(Piece piece, class_1087 pieceModel, class_1087 standModel) {
            this.piece = piece;
            this.pieceModel = pieceModel;
            this.standModel = standModel;
            modelTransformation = createModelTransformation();
        }

        private class_809 createModelTransformation() {
            class_809 modelTransformation = TransformationHelper.getMutableDefaultModelTransform();

            modelTransformation.field_4302.field_4286.y += 0.1;
            modelTransformation.field_4304.field_4286.y += 0.1;
            modelTransformation.field_4305.field_4286.z += 0.1;
            modelTransformation.field_4307.field_4286.z += 0.1;

            modelTransformation.field_4302.field_4285.set(0.55f);
            modelTransformation.field_4304.field_4285.set(0.55f);
            modelTransformation.field_4305.field_4285.set(0.55f);
            modelTransformation.field_4307.field_4285.set(0.55f);

            modelTransformation.field_4302.field_4287.y -= 90;
            modelTransformation.field_4304.field_4287.y += 90;

            modelTransformation.field_4305.field_4287.y += 90;
            modelTransformation.field_4307.field_4287.y += 90;

//            modelTransformation.fixed.translation.y -= 0.2;
            modelTransformation.field_4306.field_4286.z -= 0.1;

            modelTransformation.field_4300.field_4285.mul(1.15f);
            modelTransformation.field_4300.field_4286.y -= 0.05;
//            modelTransformation.gui.rotation.y -= 180;

            // Knights are rotated to the right in itemframe
            if(piece == Piece.WHITE_KNIGHT || piece == Piece.BLACK_KNIGHT){
                modelTransformation.field_4306.field_4287.y += 90;
            }

            return modelTransformation;
        }

        @Override
        public List<class_777> method_4707(@Nullable class_2680 state, @Nullable class_2350 face, class_5819 random) {
            return Collections.emptyList();
        }

        @Override
        public boolean method_4708() {
            return false;
        }

        @Override
        public boolean method_4713() {
            return false;
        }

        @Override
        public boolean method_4712() {
            return true;
        }

        @Override
        public boolean method_24304() {
            return true;
        }

        @Override
        public class_1058 method_4711() {
            return standModel.method_4711();
        }

        @Override
        public class_809 method_4709() {
            return modelTransformation;
        }

        @Override
        public class_806 method_4710() {
            return class_806.field_4292;
        }

        @Override
        public boolean isVanillaAdapter() {
            return false;
        }

        @Override
        public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 blockPos, Supplier<class_5819> randomSupplier, RenderContext renderContext) {
            standModel.emitBlockQuads(blockView, state, blockPos, randomSupplier, renderContext);
            renderContext.pushTransform(new QuadTransform.Scale(0.5f));
            renderContext.pushTransform(new QuadTransform.Translate(0.5f, 3/8f, 0.5f));
            pieceModel.emitBlockQuads(blockView, state, blockPos, randomSupplier, renderContext);
            renderContext.popTransform();
            renderContext.popTransform();
        }

        @Override
        public void emitItemQuads(class_1799 stack, Supplier<class_5819> randomSupplier, RenderContext renderContext) {
            standModel.emitItemQuads(stack, randomSupplier, renderContext);
            renderContext.pushTransform(new QuadTransform.Scale(0.5f));
            renderContext.pushTransform(new QuadTransform.Translate(0.5f, 3/8f, 0.5f));
            pieceModel.emitItemQuads(stack, randomSupplier, renderContext);
            renderContext.popTransform();
            renderContext.popTransform();
        }
    }
}
