package be.immersivechess.client.structure;

import be.immersivechess.item.PieceContainer;
import be.immersivechess.logic.Piece;
import com.google.common.collect.MapMaker;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_32;
import net.minecraft.class_3264;
import net.minecraft.class_3485;
import net.minecraft.class_3499;
import net.minecraft.class_6861;
import net.minecraft.class_7923;
import net.minecraft.class_8579;
import org.jetbrains.annotations.Nullable;

import java.io.IOException;
import java.util.Map;
import java.util.Optional;

@Environment(EnvType.CLIENT)
public class StructureResolver {

    private static final Map<class_2487, class_3499> cache = new MapMaker().weakValues().makeMap();

    private static final class_3485 structureTemplateManager = getStructureTemplateManager();

    private static class_3485 getStructureTemplateManager(){
        class_310 client = class_310.method_1551();

        if (client.method_1496())
            return client.method_1576().method_27727();

        try {
            // session only used to store structures -> won't be used
            class_32.class_5143 session = client.method_1586().method_52236("");
            session.close();
            class_6861 dataResourceManager = new class_6861(class_3264.field_14190, client.method_1520().method_29211());
            return new class_3485(dataResourceManager, session, client.method_1543(), class_7923.field_41175.method_46771());
        } catch (IOException | class_8579 e) {
            throw new RuntimeException(e);
        }
    }

    private static class_3499 loadStructure(class_2487 compound){
        return structureTemplateManager.method_21891(compound);
    }

    public static class_3499 getStructure(class_2487 compound){
        return cache.computeIfAbsent(compound, StructureResolver::loadStructure);
    }

    public static class_3499 getDefaultStructure(Piece piece){
        Optional<class_3499> structureTemplateOptional = structureTemplateManager.method_15094(piece.getDefaultStructureIdentifier());
        return structureTemplateOptional.orElse(null);
    }

    @Nullable
    @Environment(EnvType.CLIENT)
    public static class_3499 getStructure(class_1799 stack){
        if (!(stack.method_7909() instanceof PieceContainer pieceContainer))
            return null;

        if (pieceContainer.getPiece() == null)
            return null;

        class_2487 structureNbt = PieceContainer.getStructureNbt(stack);
        if (structureNbt.method_33133())
            return getDefaultStructure(pieceContainer.getPiece());

        return getStructure(structureNbt);
    }

}
