package be.immersivechess.item;

import be.immersivechess.ImmersiveChess;
import be.immersivechess.block.Blocks;
import be.immersivechess.block.BoardBlock;
import be.immersivechess.block.PieceBlock;
import be.immersivechess.block.entity.BoardBlockEntity;
import be.immersivechess.block.entity.StructureRenderedBlockEntity;
import be.immersivechess.logic.MultiblockBoard;
import be.immersivechess.logic.Piece;
import be.immersivechess.screen.ChessCaseScreenHandler;
import be.immersivechess.structure.StructureMap;
import be.immersivechess.world.ChessGameState;
import ch.astorm.jchess.core.Color;
import ch.astorm.jchess.core.Coordinate;
import java.util.*;
import java.util.stream.Collectors;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1277;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_3908;
import net.minecraft.class_5328;

public class ChessCase extends class_1792 {

    private static final String ITEMS_KEY = "Items";
    private static final String OPEN_KEY = "Open";


    public ChessCase(class_1793 settings) {
        super(settings);
    }


    @Override
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);

        class_3908 namedScreenHandlerFactory = new class_3908() {
            @Override
            public class_1703 createMenu(int i, class_1661 playerInventory, class_1657 playerEntity) {
                return new ChessCaseScreenHandler(i, playerInventory, ChessCase.getInventory(itemStack), itemStack);
            }

            @Override
            public class_2561 method_5476() {
                return itemStack.method_7964();
            }
        };

        ChessCase.setOpen(itemStack, true);
        player.method_17355(namedScreenHandlerFactory);
        return class_1271.method_29237(itemStack, false);
    }

    public class_1269 method_7884(class_1838 context) {
        class_1937 world = context.method_8045();
        class_2338 pos = context.method_8037();
        class_1657 player = context.method_8036();
        class_1799 chessCase = context.method_8041();

        if (player == null)
            return class_1269.field_5814;

        // when board already exists
        if (world.method_8320(pos).method_26204() instanceof BoardBlock) {
            // on server
            if (world instanceof class_3218 serverWorld) {
                if (!(world.method_8321(pos) instanceof BoardBlockEntity boardBlockEntity))
                    return class_1269.field_5811;

                ChessGameState gameState = boardBlockEntity.getGameState();
                if (gameState == null)
                    return class_1269.field_5811;

                // if game finished -> create a new game
                if (gameState.getStatus().isFinished())
                    return initializeBoard(world, player, pos, chessCase);

                // ongoing game (moves start at 1)
                if (gameState.getCurrentMoveIndex() > 1) {
                    player.method_7353(class_2561.method_43471("immersivechess.game_in_progress"), true);
                    return class_1269.field_5811;
                }

                // initial game (no moves played)
                MultiblockBoard board = gameState.getBoard();
                Color clickedSide = board.getSide(pos);

                StructureMap structures = getStructureNbtForPieces(context.method_8041());
                boolean actionPerformed = gameState.togglePlayer(clickedSide, player, structures);
                return actionPerformed ? class_1269.field_5812 : class_1269.field_5814;
            }

            return class_1269.method_29236(world.method_8608());
        }

        // Try to create a board
        return initializeBoard(world, player, pos, chessCase);
    }

    /**
     * Traces board in world, replaces with board blocks if needed, sets new ChessGameState and sets player to be black.
     */
    private class_1269 initializeBoard(class_1937 world, class_1657 player, class_2338 pos, class_1799 chessCase){
        MultiblockBoard board = MultiblockBoard.getValidBoard(world, player, pos);

        if (board == null) {
            player.method_7353(class_2561.method_43471("immersivechess.invalid_board"), true);
            return class_1269.field_5814;
        }

        // on server
        if (world instanceof class_3218 serverWorld) {
            // create a new chess game
            StructureMap structures = getStructureNbtForPieces(chessCase);
            ChessGameState gameState = ChessGameState.create(serverWorld, board);
            createBoard(world, board, gameState);
            gameState.setPlayer(Color.BLACK, player, structures);
        }

        player.method_7353(class_2561.method_43471("immersivechess.valid_board"), true);
        return class_1269.method_29236(world.method_8608());
    }


    private static void createBoard(class_1937 world, MultiblockBoard board, ChessGameState gameState) {
        // replace with BoardBlock
        class_3341 bounds = board.getBounds();
        for (class_2338 blockPos : class_2338.method_10094(bounds.method_35415(), bounds.method_35416(), bounds.method_35417(), bounds.method_35418(), bounds.method_35419(), bounds.method_35420())) {
            if (!world.method_8320(blockPos).method_27852(Blocks.BOARD_BLOCK))
                Blocks.BOARD_BLOCK.replace(world, blockPos, board.getColorOfPos(blockPos));

            // clear above
            BoardBlock.breakBlockAboveBoard(world, blockPos.method_10084());

            class_2586 entity = world.method_8321(blockPos);
            if (entity instanceof BoardBlockEntity boardBlockEntity) {
                Coordinate square = board.getSquare(blockPos);
                boardBlockEntity.setGameState(gameState);
                boardBlockEntity.setSquare(square);
            }
        }

        gameState.placePieces();
    }

    public static boolean isOpen(class_1799 stack) {
        class_2487 compound = stack.method_7969();
        if (compound != null)
            return compound.method_10577(OPEN_KEY);

        return false;
    }

    public static void setOpen(class_1799 stack, boolean state) {
        stack.method_7948().method_10556(OPEN_KEY, state);
    }

    @Override
    public boolean method_31568() {
        // The case can still be placed inside shulkers.
        // Since the case can only contain specific types, it will never cause recursive nesting with other items anyway.
        return true;
    }

    @Override
    public void method_33261(class_1542 entity) {
        super.method_33261(entity);

        class_5328.method_33263(entity, getItems(entity.method_6983()).stream());
    }

    /**
     * From the chess case item, extract the structure nbt off the piece stands depending on the settings.
     */
    public StructureMap getStructureNbtForPieces(class_1799 stack) {
        class_1263 inventory = getInventory(stack);
        return new StructureMap(Arrays.stream(Piece.values())
                .filter(p -> !inventory.method_5438(p.ordinal()).method_7960())
                .collect(Collectors.toMap(
                        p -> p,         // key
                        p -> {          // value
                            class_1799 pieceStack = inventory.method_5438(p.ordinal());

                            return PieceContainer.getStructureNbt(pieceStack);
                        })
                ));
    }

    /**
     * Creates an inventory with a listener attached that automatically syncs modifications to the item NBT.
     */
    public static class_1263 getInventory(class_1799 stack) {
        class_1277 inventory = new class_1277(2 * 6);
        List<class_1799> items = getItems(stack);
        for (int i = 0; i < items.size(); i++) {
            inventory.method_5447(i, items.get(i));
        }

        inventory.method_5489(inv -> {
            ChessCase.saveInventory(stack, inv);
        });

        return inventory;
    }

    public static boolean canContainItem(class_1792 item) {
        return item == class_1799.field_8037.method_7909() || item instanceof PieceStandItem;
    }

    private static List<class_1799> getItems(class_1799 stack) {
        class_2487 nbtCompound = stack.method_7969();
        if (nbtCompound == null) {
            return Collections.emptyList();
        }
        class_2499 nbtList = nbtCompound.method_10554(ITEMS_KEY, class_2520.field_33260);
        return nbtList.stream().map(class_2487.class::cast).map(class_1799::method_7915).toList();
    }

    private static class_2487 getOrInitializeNbt(class_1799 stack) {
        class_2487 nbtCompound = stack.method_7948();
        if (!nbtCompound.method_10545(ITEMS_KEY)) {
            nbtCompound.method_10566(ITEMS_KEY, new class_2499());
        }

        class_2499 nbtList = nbtCompound.method_10554(ITEMS_KEY, class_2520.field_33260);
        while (nbtList.size() < 2 * 6) {
            class_2487 nbtStack = new class_2487();
            class_1799.field_8037.method_7953(nbtStack);
            nbtList.add(nbtStack);
        }

        return nbtCompound;
    }

    private static void saveItems(class_1799 caseItemStack, List<class_1799> items) {
        class_2487 nbtCompound = getOrInitializeNbt(caseItemStack);

        class_2499 nbtList = nbtCompound.method_10554(ITEMS_KEY, class_2520.field_33260);
        for (int i = 0; i < items.size(); i++) {
            class_1799 itemStack = items.get(i);
            if (!canContainItem(itemStack.method_7909())) {
                ImmersiveChess.LOGGER.error("Invalid item encountered in chess case: " + itemStack);
                itemStack = class_1799.field_8037;
            }
            class_2487 nbtStack = new class_2487();
            itemStack.method_7953(nbtStack);
            nbtList.method_10606(i, nbtStack);
        }
    }

    private static void saveInventory(class_1799 stack, class_1263 inventory) {
        List<class_1799> items = new ArrayList<>(inventory.method_5439());
        for (int i = 0; i < inventory.method_5439(); i++) {
            items.add(inventory.method_5438(i));
        }
        saveItems(stack, items);
    }

}
