package be.immersivechess.item;

import be.immersivechess.ImmersiveChess;
import be.immersivechess.block.Blocks;
import be.immersivechess.block.PieceBlock;
import be.immersivechess.block.PieceStandBlock;
import be.immersivechess.block.PieceStructureBlock;
import be.immersivechess.logic.Piece;
import be.immersivechess.recipe.StandDyeRecipe;
import be.immersivechess.resource.BlockStateLuminanceMapper;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroupEntries;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import net.minecraft.item.*;
import java.util.List;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class Items {

//    public static final Item DEBUG_ITEM = register("debug", new Item(new FabricItemSettings()) {
//        @Override
//        public ActionResult useOnBlock(ItemUsageContext context) {
//            context = new ItemPlacementContext(context);
//            BlockPos pos = context.getBlockPos();
//            Direction dir = context.getHorizontalPlayerFacing();
//
//            boolean noteblockDone = false;
//            for (BlockState state : BlockStateLuminanceMapper.INSTANCE.getOrderedBlockStates()) {
//                if (state.isOf(net.minecraft.block.Blocks.NOTE_BLOCK)) {
//                    if (noteblockDone)
//                        continue;
//                    noteblockDone = true;
//                }
//                context.getWorld().setBlockState(pos, state);
//                pos = pos.offset(dir);
//            }
//
//            return ActionResult.success(context.getWorld().isClient);
//        }
//    });

    // Items
    public static final class_1792 CHESS_CASE = register("chess_case", new ChessCase(new FabricItemSettings().method_7889(1)));

    // BlockItems
    // Stands
    public static final class_1792 BLANK_STAND = register(new StandItem(Blocks.BLANK_STAND, new FabricItemSettings()));
    public static final SortedMap<Piece, PieceStandItem> PIECE_STANDS = Blocks.PIECE_STANDS.stream().collect(Collectors.toMap(
            PieceStandBlock::getPiece,
            Items::createPieceStand,
            (v1, v2) -> {
                throw new RuntimeException(String.format("Duplicate key for values %s and %s", v1, v2));
            },
            TreeMap::new)
    );

    // Pieces
    public static final SortedMap<Piece, class_1792> PIECE_ITEMS = Blocks.PIECES.values().stream().collect(Collectors.toMap(
            PieceBlock::getPiece,
            Items::createPieceBlockItems,
            (v1, v2) -> {
                throw new RuntimeException(String.format("Duplicate key for values %s and %s", v1, v2));
            },
            TreeMap::new)
    );

    public static final List<class_1792> PIECE_STRUCTURE_ITEMS = Blocks.PIECE_STRUCTURE_BLOCKS.stream().map(Items::createPieceStructureBlockItems).toList();

    private static PieceItem createPieceBlockItems(PieceBlock pieceBlock) {
        return register(new PieceItem(pieceBlock, new FabricItemSettings().method_7889(1)));
    }

    private static class_1792 createPieceStructureBlockItems(PieceStructureBlock pieceStructureBlock) {
        return register(pieceStructureBlock);
    }

    private static PieceStandItem createPieceStand(PieceStandBlock pieceStandBlock) {
        return register(new PieceStandItem(pieceStandBlock, new FabricItemSettings().method_7889(1)));
    }

    private static class_1747 register(class_2248 block) {
        return Items.register(new class_1747(block, new FabricItemSettings()));
    }

    private static <T extends class_1747> T register(T item) {
        return Items.register(item.method_7711(), item);
    }

    protected static <T extends class_1792> T register(class_2248 block, T item) {
        return Items.register(class_7923.field_41175.method_10221(block), item);
    }

    private static <T extends class_1792> T register(String id, T item) {
        return Items.register(new class_2960(ImmersiveChess.MOD_ID, id), item);
    }

    private static <T extends class_1792> T register(class_2960 id, T item) {
        return class_2378.method_10230(class_7923.field_41178, id, item);
    }

    // Item Groups
    public static final class_1761 IC_GROUP = register(
            new class_2960(ImmersiveChess.MOD_ID, "immersivechess"),
            FabricItemGroup.builder()
                    .method_47320(() -> new class_1799(CHESS_CASE))
    );

    private static class_1761 register(class_2960 id, class_1761.class_7913 builder) {
        class_1761 group = builder
                .method_47321(class_2561.method_43471(id.method_42093("itemGroup")))
                .method_47324();
        return class_2378.method_10230(class_7923.field_44687, id, group);
    }

    public static void onInitialize() {
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_41060).register(content -> {
            content.method_45421(CHESS_CASE);

            // debug items
//            content.add(DEBUG_ITEM);
        });

        ItemGroupEvents.modifyEntriesEvent(class_7706.field_41062).register(content -> {
            addStandsToItemGroup(content);
        });

        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40197).register(content -> {
            PIECE_STRUCTURE_ITEMS.forEach(content::method_45421);
        });

        ItemGroupEvents.modifyEntriesEvent(class_7706.field_41059).register(content -> {

        });

        // also add everything to immersivechess tab
        ItemGroupEvents.modifyEntriesEvent(class_7923.field_44687.method_29113(IC_GROUP).get()).register(content -> {
            content.method_45421(CHESS_CASE);
            PIECE_STRUCTURE_ITEMS.forEach(content::method_45421);
            addStandsToItemGroup(content);
        });
    }

    private static void addStandsToItemGroup(FabricItemGroupEntries content) {
        content.method_45421(BLANK_STAND);

        // stands in all colors
        for (class_1767 dyeColor : class_1767.values()) {
            // yellow is added as undyed beacuse it is the default
            if (dyeColor.equals(StandItem.DEFAULT_COLOR))
                continue;

            class_1799 stand = new class_1799(BLANK_STAND);
            PieceContainer.writeColor(stand, StandDyeRecipe.dyeColorToColor(dyeColor));
            content.method_45420(stand);
        }

        // Piece stands with default structures are registered on the client
    }

}
