package be.immersivechess.item;

import be.immersivechess.ImmersiveChess;
import be.immersivechess.block.entity.PieceBlockEntity;
import be.immersivechess.logic.Piece;
import ch.astorm.jchess.core.Coordinate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;

public interface PieceContainer {

    // under BlockItem.BLOCK_ENTITY_TAG_KEY
    String NBT_STRUCTURE_KEY = "Structure";
    String NBT_COLOR_KEY = "Color";

    // in root nbt
    String NBT_GAME_ID_KEY = "GameId";
    String NBT_MOVE_INDEX_KEY = "MoveIndex";
    String NBT_SOURCE_SQUARE_KEY = "SourceSquare";
    String NBT_DESTINATION_SQUARES_KEY = "DestinationSquares";

    Piece getPiece();

    static Piece getPiece(class_1799 stack) {
        if (stack.method_7909() instanceof PieceContainer pieceContainer)
            return pieceContainer.getPiece();
        return null;
    }

    static void writeStructureNbt(class_1799 stack, class_2487 structureNbt) {
        class_2487 nbt = stack.method_7911(class_1747.field_30849);
        nbt.method_10566(NBT_STRUCTURE_KEY, structureNbt);
    }

    @NotNull
    static class_2487 getStructureNbt(class_1799 stack) {
        class_2487 nbt = stack.method_7941(class_1747.field_30849);
        if (nbt != null && nbt.method_10545(PieceContainer.NBT_STRUCTURE_KEY))
            return nbt.method_10562(PieceContainer.NBT_STRUCTURE_KEY);

        // empty compound indicates use of default structure
        return new class_2487();
    }

    static void writeColor(class_1799 stack, int color) {
        class_2487 nbt = stack.method_7911(class_1747.field_30849);
        nbt.method_10569(NBT_COLOR_KEY, color);
    }

    static int getColor(class_1799 stack) {
        class_2487 nbt = stack.method_7941(class_1747.field_30849);
        if (nbt != null && nbt.method_10545(PieceContainer.NBT_COLOR_KEY))
            return nbt.method_10550(PieceContainer.NBT_COLOR_KEY);

        return StandItem.DEFAULT_COLOR_INT;
    }

    static void removeColor(class_1799 stack){
        class_2487 nbt = stack.method_7941(class_1747.field_30849);
        if (nbt == null) return;

        if (nbt.method_10545(PieceContainer.NBT_COLOR_KEY))
            nbt.method_10551(PieceContainer.NBT_COLOR_KEY);

        if (nbt.method_33133())
            stack.method_7983(class_1747.field_30849);
    }

    static class_2487 getGameInfo(class_1799 stack){
        if (!stack.method_7985() || !stack.method_7969().method_10545(PieceBlockEntity.NBT_GAME_INFO)) return null;
        return stack.method_7969().method_10562(PieceBlockEntity.NBT_GAME_INFO);
    }

    static class_2487 getOrCreateGameInfo(class_1799 stack){
        return stack.method_7911(PieceBlockEntity.NBT_GAME_INFO);
    }

    /**
     * Extract origin from where this piece was mined. Not every PieceContainer will have this.
     */
    @Nullable
    static Coordinate getSourceSquare(class_1799 stack) {
        class_2487 nbt = getGameInfo(stack);
        if (nbt == null || !nbt.method_10545(NBT_SOURCE_SQUARE_KEY)) return null;

        String squareStr = nbt.method_10558(NBT_SOURCE_SQUARE_KEY);
        try{
            return new Coordinate(squareStr);
        } catch (IllegalArgumentException e){
            ImmersiveChess.LOGGER.error("Failed to convert piece nbt to square", e);
            return null;
        }
    }

    @Nullable
    static String getGameSaveId(class_1799 stack) {
        class_2487 nbt = getGameInfo(stack);
        if (nbt == null || !nbt.method_10545(NBT_GAME_ID_KEY)) return null;

        return nbt.method_10558(NBT_GAME_ID_KEY);
    }

    /**
     * Gets the index this move would be once the piece is placed. Returning 0 means missing value.
     */
    static int getMoveIndex(class_1799 stack) {
        class_2487 nbt = getGameInfo(stack);
        if (nbt == null || !nbt.method_10545(NBT_MOVE_INDEX_KEY)) return 0;

        return nbt.method_10550(NBT_MOVE_INDEX_KEY);
    }

    static List<Coordinate> getDestinationSquares(class_1799 stack){
        class_2487 nbt = getGameInfo(stack);
        if (nbt == null || !nbt.method_10545(NBT_DESTINATION_SQUARES_KEY)) return Collections.emptyList();

        class_2499 squareStrs = nbt.method_10554(NBT_DESTINATION_SQUARES_KEY, class_2520.field_33258);
        List<Coordinate> destinations = new ArrayList<>();
        for (int i =0; i < squareStrs.size(); i++){
            String squareStr = squareStrs.method_10608(i);
            try{
                destinations.add(new Coordinate(squareStr));
            } catch (IllegalArgumentException e){
                ImmersiveChess.LOGGER.error("Failed to convert piece nbt to square", e);
            }
        }
        return destinations;
    }

    static void writeGameSaveId(class_1799 stack, String gameId){
        getOrCreateGameInfo(stack).method_10582(NBT_GAME_ID_KEY, gameId);
    }

    static void writeMoveIndex(class_1799 stack, int moveIndex){
        getOrCreateGameInfo(stack).method_10569(NBT_MOVE_INDEX_KEY, moveIndex);
    }

    /**
     * Write origin from where this piece was mined from.
     */
    static void writeSourceSquare(class_1799 stack, Coordinate square) {
        getOrCreateGameInfo(stack).method_10582(NBT_SOURCE_SQUARE_KEY, square.toString());
    }

    /**
     * Write valid move destinations to stack nbt.
     */
    static void writeDestinations(class_1799 stack, List<Coordinate> destinations) {
        class_2499 nbtDestinations = new class_2499();
        destinations.stream()
                .map(Coordinate::toString)
                .forEach(s -> nbtDestinations.add(class_2519.method_23256(s)));
        getOrCreateGameInfo(stack).method_10566(PieceContainer.NBT_DESTINATION_SQUARES_KEY, nbtDestinations);
    }


}
