package be.immersivechess.item;

import be.immersivechess.ImmersiveChess;
import be.immersivechess.block.PieceBlock;
import be.immersivechess.block.entity.BoardBlockEntity;
import be.immersivechess.logic.Piece;
import be.immersivechess.world.ChessGameState;
import ch.astorm.jchess.core.Coordinate;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_6862;
import net.minecraft.class_7924;

public class PieceItem extends class_1747 implements PieceContainer {

    public static final class_6862<class_1792> PIECE_TAG = class_6862.method_40092(class_7924.field_41197, new class_2960(ImmersiveChess.MOD_ID, "piece"));

    private final Piece piece;

    public PieceItem(PieceBlock pieceBlock, class_1793 settings) {
        super(pieceBlock, settings);
        this.piece = pieceBlock.getPiece();
    }

    @Override
    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        super.method_7888(stack, world, entity, slot, selected);
        if (removeIfInvalid(stack, world, entity, slot)) return;
    }

    /**
     * Removes piece from inventory if not valid. Returns true if it was removed
     */
    private boolean removeIfInvalid(class_1799 stack, class_1937 world, class_1297 entity, int slot){
        if (!(world instanceof class_3218 serverWorld)) return false;
        if (entity instanceof class_1657 player && player.method_7338()) return false;

        // invalid piece -> discard
        String gameId = PieceContainer.getGameSaveId(stack);
        if (gameId == null) return removeFromInventory(entity, slot);
        ChessGameState gameState = ChessGameState.get(serverWorld, gameId);
        if (gameState == null) return removeFromInventory(entity, slot);
        int turn = PieceContainer.getMoveIndex(stack);
        if (turn == 0) return removeFromInventory(entity, slot);

        // game finished -> discard
        // Note: not using isPlayAllowed because for a draw this would be true
        if (gameState.getStatus().isFinished()) return removeFromInventory(entity, slot);

        // piece from different turn -> discard
        if (!gameState.hasPlayerMinedPiece() || turn != gameState.getCurrentMoveIndex()) return removeFromInventory(entity, slot);

        // piece from another player -> drop
        if (entity instanceof class_1657 playerEntity && !gameState.isPlayerOnMove(playerEntity)) return dropFromInventory(entity, slot);

        return false;
    }

    private boolean removeFromInventory(class_1297 entity, int slot){
        if (entity instanceof class_1657 playerEntity){
            playerEntity.method_31548().method_5441(slot);
            return true;
        }
        return false;
    }

    private boolean dropFromInventory(class_1297 entity, int slot){
        if (entity instanceof class_1657 playerEntity){
            class_1799 stack = playerEntity.method_31548().method_5441(slot);
            playerEntity.method_7328(stack, false);
            return true;
        }
        return false;
    }

    @Override
    public Piece getPiece() {
        return piece;
    }

    @Override
    protected boolean method_7709(class_1750 context, class_2680 state) {
        // TODO: might override player collision check here as well
        if (!super.method_7709(context, state))
            return false;

        if (context.method_8045().field_9236) return false;
        if (context.method_8036() != null && context.method_8036().method_7338()) return true;

        // if not on board don't allow placement
        if (!(context.method_8045().method_8321(context.method_8037().method_10074()) instanceof BoardBlockEntity boardBlockEntity)) return false;
        ChessGameState gameState = boardBlockEntity.getGameState();
        if (gameState == null) return false;

        Coordinate destination = boardBlockEntity.getSquare();
        return PieceContainer.getDestinationSquares(context.method_8041()).contains(destination);
    }
}
