package be.immersivechess.recipe;

import be.immersivechess.item.PieceContainer;
import be.immersivechess.item.StandItem;
import java.util.Optional;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_3545;
import net.minecraft.class_5253;
import net.minecraft.class_5455;
import net.minecraft.class_7710;
import net.minecraft.class_8566;

public class StandDyeRecipe extends class_1852 {
    public StandDyeRecipe(class_7710 category) {
        super(category);
    }

    @Override
    public boolean matches(class_8566 inventory, class_1937 world) {
        return parseIngredients(inventory).isPresent();
    }

    /**
     * Return ItemStack of StandItem to be dyed and single dyeitem if recipe is valid.
     */
    private Optional<class_3545<class_1799, class_1769>> parseIngredients(class_8566 inventory) {
        // check whether grid contains exactly one stand and one dye
        class_1799 standItemStack = class_1799.field_8037;
        class_1769 dyeItem = null;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 itemStack = inventory.method_5438(i);
            if (itemStack.method_7960())
                continue;
            if (itemStack.method_7909() instanceof StandItem) {
                if (!standItemStack.method_7960())
                    return Optional.empty();

                standItemStack = itemStack;
                continue;
            }
            if (itemStack.method_7909() instanceof class_1769 inventoryDyeItem) {
                if (dyeItem != null)
                    return Optional.empty();

                dyeItem = inventoryDyeItem;
                continue;
            }

            return Optional.empty();
        }
        if (standItemStack.method_7960() || dyeItem == null)
            return Optional.empty();

        return Optional.of(new class_3545<>(standItemStack, dyeItem));
    }

    @Override
    public class_1799 craft(class_8566 inventory, class_5455 registryManager) {
        Optional<class_3545<class_1799, class_1769>> parsedIngredients = parseIngredients(inventory);
        if (parsedIngredients.isEmpty())
            return class_1799.field_8037;

        class_3545<class_1799, class_1769> ingredients = parsedIngredients.get();

        class_1799 result = ingredients.method_15442().method_46651(1);
        class_1767 dye = ingredients.method_15441().method_7802();
        int color = dyeColorToColor(dye);

        if (dye.equals(StandItem.DEFAULT_COLOR))
            PieceContainer.removeColor(result);
        else
            PieceContainer.writeColor(result, color);

        return result;
    }

    public boolean method_8113(int width, int height) {
        return width * height >= 2;
    }

    public static int dyeColorToColor(class_1767 dyeColor) {
        float[] colComp = dyeColor.method_7787();
        return class_5253.class_5254.method_27764(255, (int) (colComp[0] * 255), (int) (colComp[1] * 255), (int) (colComp[2] * 255));
    }

    @Override
    public class_1865<?> method_8119() {
        return Recipes.STAND_DYE;
    }
}
