package be.immersivechess.resource;

import be.immersivechess.ImmersiveChess;
import be.immersivechess.util.BlockStateUtil;
import ch.astorm.jchess.core.Color;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import org.jetbrains.annotations.Nullable;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BlockStateLuminanceMapper extends class_4080<Map<class_2680, Double>> implements IdentifiableResourceReloadListener {
    public static final BlockStateLuminanceMapper INSTANCE = new BlockStateLuminanceMapper();

    // Parsing info
    private static final class_2960 BLOCK_COLORS_FILE_ID = new class_2960(ImmersiveChess.MOD_ID, "chess/block_colors.json");
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(class_2680.class, new BlockStateTypeAdapter()).create();

    // definition for Gson
    public static class BlockColorsJson {
        public Map<class_2680, Double> blockstates = new HashMap<>();
    }

    // private attributes
    private Map<class_2680, Double> blockStateLuminances = Collections.emptyMap();
    private double averageLuminance = 50;

    @Nullable
    public Color getColorOfFirstBlock(class_2680 state1, class_2680 state2) {
        return getLuminance(state1) > getLuminance(state2) ? Color.WHITE : Color.BLACK;
    }

    public double getLuminance(class_2680 state) {
        return blockStateLuminances.getOrDefault(state, averageLuminance);
    }

    // For debugging mostly
    public List<class_2680> getOrderedBlockStates(){
        return blockStateLuminances.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(Map.Entry::getKey).toList();
    }

    @Override
    public class_2960 getFabricId() {
        return new class_2960(ImmersiveChess.MOD_ID, method_22322().toLowerCase());
    }

    @Override
    protected Map<class_2680, Double> method_18789(class_3300 manager, class_3695 profiler) {
        profiler.method_16065();

        Map<class_2680, Double> allData = new HashMap<>();

        // Multiple datapacks might have this resource.
        // By processing all of them we can allow these values to be overridden.
        for (class_3298 resource : manager.method_14489(BLOCK_COLORS_FILE_ID)) {
            try (BufferedReader reader = resource.method_43039()) {
                BlockColorsJson jsonData = class_3518.method_15276(GSON, reader, BlockColorsJson.class);
                if (jsonData.blockstates == null)
                    throw new JsonSyntaxException("Missing attribute 'blockstates' in block colors json");

                allData.putAll(jsonData.blockstates);
            } catch (IOException e) {
                ImmersiveChess.LOGGER.error("Error occurred while loading resource '" + BLOCK_COLORS_FILE_ID + "' from pack '" + resource.method_14480() + "'", e);
            }
        }
        profiler.method_16066();
        return allData;
    }

    @Override
    protected void apply(Map<class_2680, Double> prepared, class_3300 manager, class_3695 profiler) {
        profiler.method_16065();
        blockStateLuminances = prepared;
        averageLuminance = blockStateLuminances.values().stream().mapToDouble(v -> v).average().orElse(50);
        profiler.method_16066();
    }

    // See `BoardColorMapper.GSON` for usage of this outside of the class
    private static class BlockStateTypeAdapter extends TypeAdapter<class_2680> {
        @Override
        public void write(JsonWriter jsonWriter, class_2680 blockState) throws IOException {
            jsonWriter.value(blockState.toString());
        }

        @Override
        public class_2680 read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();

            class_2680 state = BlockStateUtil.getBlockStateWithName(value);
            if (state == null)
                throw new JsonSyntaxException("Could not find BLockState for " + value);

            return state;
        }
    }

}
