package be.immersivechess.screen;

import be.immersivechess.item.ChessCase;
import be.immersivechess.logic.Piece;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;

public class ChessCaseScreenHandler extends class_1703 {

    private final class_1263 inventory;

    private final class_1799 caseItemStack;

    private final int INVENTORY_SIZE = 2 * 6;

    public ChessCaseScreenHandler(int syncId, class_1661 playerInventory) {
        this(syncId, playerInventory, new class_1277(2 * 6), class_1799.field_8037);
    }

    public ChessCaseScreenHandler(int syncId, class_1661 playerInventory, class_1263 inventory, class_1799 caseItemStack){
        super(ScreenHandlerTypes.CHESS_CASE_SCREEN_HANDLER_TYPE, syncId);
        this.inventory = inventory;
        this.caseItemStack = caseItemStack;
        inventory.method_5435(playerInventory.field_7546);

        // chess case inventory
        for (int row = 0; row < 2; ++row) {
            for (int col = 0; col < 6; ++col) {
                Piece piece = Piece.values()[col + row * 6];
                this.method_7621(new FilteredPieceSlot(inventory, col + row * 6, 27 + col * 21, 23 + row * 23, piece));
            }
        }

        // player inventory
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.method_7621(new class_1735(playerInventory, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }

        // player hotbar
        for (int col = 0; col < 9; ++col) {
            this.method_7621(new class_1735(playerInventory, col, 8 + col * 18, 142));
        }
    }

    @Override
    public class_1799 method_7601(class_1657 player, int slot) {
        class_1799 itemStack = class_1799.field_8037;
        class_1735 slot2 = this.field_7761.get(slot);
        if (slot2 != null && slot2.method_7681()) {
            class_1799 itemStack2 = slot2.method_7677();
            itemStack = itemStack2.method_7972();
            if(slot < INVENTORY_SIZE){
                if(!this.method_7616(itemStack2, INVENTORY_SIZE, this.field_7761.size(), true)){
                    return class_1799.field_8037;
                }
            }else{
                if(!this.method_7616(itemStack2, 0, INVENTORY_SIZE, false)){
                    return class_1799.field_8037;
                }
            }
            if (itemStack2.method_7960()) {
                slot2.method_53512(class_1799.field_8037);
            } else {
                slot2.method_7668();
            }
        }
        return itemStack;
    }

    @Override
    public boolean method_7613(class_1799 stack, class_1735 slot) {
        // NOTE: this function doesn't seem to prevent items from being put into the slot at all..
        // case can only contain specific items
        if(slot.field_7871 == this.inventory){
            return ChessCase.canContainItem(stack.method_7909()) && super.method_7613(stack, slot);
        }
        return super.method_7613(stack, slot);
    }

    @Override
    public boolean method_7597(class_1657 player) {
        return this.inventory.method_5443(player);
    }

    @Override
    public void method_7595(class_1657 player) {
        super.method_7595(player);
        if (caseItemStack.method_7960())
            return;

//        ImmersiveChess.LOGGER.info("Screen closed");
        ChessCase.setOpen(caseItemStack, false);
    }
}
