package be.immersivechess.structure;

import be.immersivechess.mixin.MixinStructureAccessor;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_2338;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_3492;
import net.minecraft.class_3499;

public class StructureHelper {

    public static List<class_3499.class_3501> getBlockInfoList(class_3499 structure){
        List<class_3499.class_5162> blockInfoLists = ((MixinStructureAccessor) structure).getBlockInfoLists();
        if (blockInfoLists.isEmpty()){
            return new ArrayList<>();
        }else if (blockInfoLists.size() > 1){
            throw new IllegalStateException("getBlockInfoList() called on a structure with multiple palettes");
        }
        return blockInfoLists.get(0).method_27125();
    }

    public static Map<class_2338, class_2680> buildBlockStateMap(class_3499 structure){
        List<class_3499.class_3501> blockInfoList = getBlockInfoList(structure);
        return blockInfoList.stream().collect(Collectors.toMap(s -> s.comp_1341(), s -> s.comp_1342()));
    }

    public static class_3499 rotate(class_3499 structure, class_2470 rotation){
        // extract data from structureTemplate
        List<class_3499.class_3501> blockInfos = getBlockInfoList(structure);

        // rotation
        class_3492 placementData = new class_3492().method_15123(rotation);
        class_2338 offset = structure.method_15167(class_2338.field_10980, class_2415.field_11302, rotation);
        List<class_3499.class_3501> blockInfos2 = Lists.newArrayList();
        for (class_3499.class_3501 structureBlockInfo : blockInfos) {
            class_2338 blockPos = class_3499.method_15171(placementData, structureBlockInfo.comp_1341()).method_10081(offset);
            class_2680 blockState = structureBlockInfo.comp_1342().method_26186(rotation);
            class_3499.class_3501 structureBlockInfo2 = new class_3499.class_3501(blockPos, blockState, structureBlockInfo.comp_1343() != null ? structureBlockInfo.comp_1343().method_10553() : null);
            blockInfos2.add(structureBlockInfo2);
        }

        // write list back to StructureTemplate
        List<class_3499.class_5162> blockInfoLists = ((MixinStructureAccessor) structure).getBlockInfoLists();
        blockInfoLists.clear();
        blockInfoLists.add(new class_3499.class_5162(blockInfos2));

        return structure;
    }

}
