package be.immersivechess.structure;

import be.immersivechess.ImmersiveChess;
import be.immersivechess.logic.Piece;
import ch.astorm.jchess.core.Color;
import org.jetbrains.annotations.NotNull;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3485;
import net.minecraft.class_3499;

public class StructureMap extends HashMap<Piece, class_2487> {
    // Only loaded once
    private static StructureMap DEFAULT_STRUCTURES;

    public StructureMap() {
        super();
    }

    public StructureMap(Map<? extends Piece, ? extends class_2487> m) {
        super(m);
    }

    public static StructureMap getDefault(class_3218 world){
        if (DEFAULT_STRUCTURES == null){
            DEFAULT_STRUCTURES = loadDefault(world);
        }
        return DEFAULT_STRUCTURES;
    }

    public boolean hasAnyOf(Color color){
        for (Piece piece : this.keySet()){
            if (piece.getColor() == color)
                return true;
        }
        return false;
    }

    public class_2487 writeNbt(class_2487 nbt) {
        for (Entry<Piece, class_2487> e : this.entrySet()) {
            nbt.method_10566(e.getKey().toString(), e.getValue());
        }
        return nbt;
    }

    @NotNull
    public static StructureMap fromNbt(class_2487 nbt) {
        StructureMap structures = new StructureMap();

        for (Piece piece : Piece.values()) {
            if (nbt.method_10545(piece.toString()))
                structures.put(piece, nbt.method_10562(piece.toString()));
        }

        return structures;
    }

    private static StructureMap loadDefault(class_3218 world) {
        class_3485 structureTemplateManager = world.method_8503().method_27727();
        StructureMap structures = new StructureMap();
        for (Piece piece : Piece.values()) {
            Optional<class_3499> structure = structureTemplateManager.method_15094(piece.getDefaultStructureIdentifier());
            if (structure.isEmpty()){
                ImmersiveChess.LOGGER.error("Failed to load default structure for piece: " + piece);
                continue;
            }

            structures.put(piece, structure.get().method_15175(new class_2487()));
        }

        return structures;
    }
}
