package be.immersivechess.util;

import com.google.gson.JsonSyntaxException;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class BlockStateUtil {

    @Nullable
    public static class_2680 getBlockStateWithName(String name) {
        if (!name.startsWith("Block{"))
            throw new JsonSyntaxException("Invalid BlockState identifier: " + name);

        String blockId = name.substring(6, name.indexOf('}'));
        class_2248 block = class_7923.field_41175.method_10223(new class_2960(blockId));

        return getBlockStateWithName(block, name);
    }

    @Nullable
    private static class_2680 getBlockStateWithName(class_2248 block, String name) {
        for (class_2680 state : block.method_9595().method_11662()) {
            if (state.toString().equals(name))
                return state;
        }
        return null;
    }

}
