package be.immersivechess.world;

import ch.astorm.jchess.core.Color;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2561;

public enum PieceRenderOption {
    DEFAULT,
    OWN,
    OPPONENT;

    public class_2561 getText() {
        return class_2561.method_43471("immersivechess.piece_render_option." + toString().toLowerCase());
    }

    public static PieceRenderOption get(int index) {
        if (index < 0 || index > PieceRenderOption.values().length)
            throw new IllegalArgumentException();

        return PieceRenderOption.values()[index];
    }

    public static Map<Color, PieceRenderOption> createDefaultRenderOptions(){
        Map<Color, PieceRenderOption> ret = new HashMap<>();
        ret.put(Color.WHITE, DEFAULT);
        ret.put(Color.BLACK, DEFAULT);
        return ret;
    }
}
