/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.mobspropertiesrandomness.data.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import insane96mcp.mobspropertiesrandomness.data.json.condition.MPRCondition;
import insane96mcp.mobspropertiesrandomness.data.json.condition.MPRConditionable;
import insane96mcp.mobspropertiesrandomness.data.json.property.MPRProperty;
import java.lang.reflect.Type;
import java.util.List;
import net.minecraft.world.entity.LivingEntity;

@JsonAdapter(value=Serializer.class)
public class MPRProperties
extends MPRConditionable {
    protected List<MPRProperty> properties;

    public MPRProperties(List<MPRProperty> properties, List<MPRCondition> conditions) {
        super(conditions);
        this.properties = properties;
    }

    public void tryApply(LivingEntity living) {
        if (!MPRCondition.conditionsApply(this.conditions, living)) {
            return;
        }
        this.apply(living);
    }

    public void apply(LivingEntity living) {
        for (MPRProperty property : this.properties) {
            property.tryApply(living);
        }
    }

    public void forceApply(LivingEntity living) {
        for (MPRProperty property : this.properties) {
            property.apply(living);
        }
    }

    public static List<MPRProperty> deserializeProperties(JsonObject jObject, JsonDeserializationContext context) {
        return MPRProperty.deserializeList(jObject, "properties", context);
    }

    @Override
    public JsonObject endSerialization(JsonObject jObject, JsonSerializationContext context) {
        jObject.add("properties", context.serialize(this.properties));
        super.endSerialization(jObject, context);
        return jObject;
    }

    public static class Serializer
    implements JsonDeserializer<MPRProperties>,
    JsonSerializer<MPRProperties> {
        public MPRProperties deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jObject = json.getAsJsonObject();
            return new MPRProperties(MPRProperties.deserializeProperties(jObject, context), MPRCondition.deserializeConditions(jObject, context));
        }

        public JsonElement serialize(MPRProperties src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jObject = new JsonObject();
            return src.endSerialization(jObject, context);
        }
    }
}

