/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.mobspropertiesrandomness.data.json.condition;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import insane96mcp.insanelib.util.MCUtils;
import insane96mcp.mobspropertiesrandomness.data.json.condition.MPRCondition;
import insane96mcp.mobspropertiesrandomness.data.json.util.PlayerMode;
import insane96mcp.mobspropertiesrandomness.util.SerializerUtils;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

@JsonAdapter(value=Serializer.class)
public class MPRAdvancementCondition
extends MPRCondition {
    public List<ResourceLocation> advancements;
    public PlayerMode player;

    public MPRAdvancementCondition(List<ResourceLocation> advancements, PlayerMode player, boolean inverted) {
        super(inverted);
        this.advancements = advancements;
        this.player = player;
    }

    @Override
    protected boolean conditionCheck(LivingEntity living) {
        List<ServerPlayer> players = new ArrayList();
        if (this.player == PlayerMode.NEAREST) {
            ServerPlayer nearestPlayer = (ServerPlayer)living.m_9236_().m_45930_((Entity)living, 128.0);
            if (nearestPlayer == null) {
                return false;
            }
            players.add(nearestPlayer);
        } else {
            players = living.m_9236_().m_45976_(ServerPlayer.class, living.m_20191_().m_82400_(128.0));
            if (players.isEmpty()) {
                return false;
            }
        }
        for (ServerPlayer player : players) {
            boolean allAdvancementDone = true;
            for (ResourceLocation adv : this.advancements) {
                if (MCUtils.isAdvancementDone((ServerPlayer)player, (ResourceLocation)adv)) continue;
                allAdvancementDone = false;
            }
            if (!allAdvancementDone) continue;
            return true;
        }
        return false;
    }

    public static class Serializer
    implements JsonDeserializer<MPRAdvancementCondition>,
    JsonSerializer<MPRAdvancementCondition> {
        public MPRAdvancementCondition deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jObject = json.getAsJsonObject();
            List<ResourceLocation> advancementsList = SerializerUtils.deserializeLocationList(jObject, "advancements", context);
            PlayerMode playerMode = PlayerMode.NEAREST;
            if (jObject.has("player")) {
                playerMode = (PlayerMode)((Object)GsonHelper.m_13836_((JsonObject)jObject, (String)"player", (JsonDeserializationContext)context, PlayerMode.class));
            }
            return new MPRAdvancementCondition(advancementsList, playerMode, MPRCondition.deserializeInverted(jObject));
        }

        public JsonElement serialize(MPRAdvancementCondition src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jObject = new JsonObject();
            SerializerUtils.serializeLocationList(jObject, "advancements", context, src.advancements);
            jObject.add("player", context.serialize((Object)src.player));
            return src.endSerialization(jObject);
        }
    }
}

