/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.mobspropertiesrandomness.data.json.condition;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import insane96mcp.insanelib.data.IdTagMatcher;
import insane96mcp.mobspropertiesrandomness.data.json.condition.MPRCondition;
import java.lang.reflect.Type;
import java.util.List;
import net.minecraft.world.entity.LivingEntity;

@JsonAdapter(value=Serializer.class)
public class MPRBiomeCondition
extends MPRCondition {
    List<IdTagMatcher> biomes;

    public MPRBiomeCondition(List<IdTagMatcher> biomes, boolean inverted) {
        super(inverted);
        this.biomes = biomes;
    }

    @Override
    protected boolean conditionCheck(LivingEntity living) {
        for (IdTagMatcher dimension : this.biomes) {
            if (!dimension.matchesBiome(living.m_9236_().m_204166_(living.m_20183_()))) continue;
            return true;
        }
        return false;
    }

    public static class Serializer
    implements JsonDeserializer<MPRBiomeCondition>,
    JsonSerializer<MPRBiomeCondition> {
        public MPRBiomeCondition deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jObject = json.getAsJsonObject();
            JsonArray aBiomes = jObject.getAsJsonArray("biomes");
            if (aBiomes == null) {
                throw new JsonParseException("Missing biomes array");
            }
            List values = (List)context.deserialize((JsonElement)aBiomes, IdTagMatcher.LIST_TYPE);
            return new MPRBiomeCondition(values, MPRCondition.deserializeInverted(jObject));
        }

        public JsonElement serialize(MPRBiomeCondition src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jObject = new JsonObject();
            jObject.add("biomes", context.serialize(src.biomes));
            return src.endSerialization(jObject);
        }
    }
}

