/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.mobspropertiesrandomness.data.json.condition;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import insane96mcp.mobspropertiesrandomness.data.json.condition.MPRCondition;
import insane96mcp.mobspropertiesrandomness.util.SerializerUtils;
import java.lang.reflect.Type;
import java.util.List;
import net.minecraft.world.entity.LivingEntity;

@JsonAdapter(value=Serializer.class)
public class MPRMoonPhaseCondition
extends MPRCondition {
    protected List<MoonPhase> moonPhases;

    public MPRMoonPhaseCondition(List<MoonPhase> moonPhases, boolean inverted) {
        super(inverted);
        this.moonPhases = moonPhases;
    }

    @Override
    protected boolean conditionCheck(LivingEntity living) {
        for (MoonPhase moonPhase : this.moonPhases) {
            if (moonPhase != MoonPhase.of(living.m_9236_().m_46941_())) continue;
            return true;
        }
        return false;
    }

    public static enum MoonPhase {
        FULL_MOON,
        WANING_GIBBOUS,
        LAST_QUARTER,
        WANING_CRESCENT,
        NEW_MOON,
        WAXING_CRESCENT,
        FIRST_QUARTER,
        WAXING_GIBBOUS;

        private static final MoonPhase[] PHASES;

        public static MoonPhase of(int moonPhase) {
            return PHASES[moonPhase];
        }

        static {
            PHASES = MoonPhase.values();
        }
    }

    public static class Serializer
    implements JsonDeserializer<MPRMoonPhaseCondition>,
    JsonSerializer<MPRMoonPhaseCondition> {
        public MPRMoonPhaseCondition deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jObject = json.getAsJsonObject();
            List<MoonPhase> values = SerializerUtils.deserializeList(jObject, "phases", context, MoonPhase.class);
            if (values.isEmpty()) {
                throw new JsonParseException("No moon_phases specified for Moon Phase Condition");
            }
            return new MPRMoonPhaseCondition(values, MPRCondition.deserializeInverted(jObject));
        }

        public JsonElement serialize(MPRMoonPhaseCondition src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jObject = new JsonObject();
            jObject.add("phases", context.serialize(src.moonPhases));
            return src.endSerialization(jObject);
        }
    }
}

