/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.mobspropertiesrandomness.data.json.property.equipment;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import insane96mcp.insanelib.util.weightedrandom.WeightedRandom;
import insane96mcp.mobspropertiesrandomness.data.json.WeightedLootTable;
import insane96mcp.mobspropertiesrandomness.data.json.WeightedResourceLocation;
import insane96mcp.mobspropertiesrandomness.data.json.condition.MPRCondition;
import insane96mcp.mobspropertiesrandomness.data.json.property.MPRProperty;
import insane96mcp.mobspropertiesrandomness.data.json.property.equipment.MPRItem;
import insane96mcp.mobspropertiesrandomness.data.json.property.equipment.MPRItemFunction;
import insane96mcp.mobspropertiesrandomness.util.SerializerUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

@JsonAdapter(value=Serializer.class)
public class MPREquipmentProperty
extends MPRProperty {
    public EquipmentSlot slot;
    public List<MPRItem> items;
    public List<WeightedLootTable> lootTables;
    public List<MPRItemFunction> functions;

    public MPREquipmentProperty(EquipmentSlot slot, List<MPRItem> items, List<WeightedLootTable> lootTables, List<MPRItemFunction> functions, List<MPRCondition> conditions) {
        super(conditions);
        this.slot = slot;
        this.items = items;
        this.functions = functions;
        this.lootTables = lootTables;
    }

    @Override
    public boolean apply(LivingEntity living) {
        MPRItem randomItem = this.getRandomItem(living);
        ItemStack stack = randomItem != null ? randomItem.getStack(living, this.slot) : this.getRandomItemFromLootTable(living);
        if (stack == null || stack.m_41619_()) {
            stack = living.m_6844_(this.slot);
            if (stack.m_41619_()) {
                return false;
            }
            this.applyItem(living, stack, false);
        } else {
            this.applyItem(living, stack, true);
        }
        return true;
    }

    private void applyItem(LivingEntity living, ItemStack stack, boolean setItemToSlot) {
        for (MPRItemFunction function : this.functions) {
            function.tryApply(living, stack, this.slot);
        }
        if (setItemToSlot) {
            living.m_8061_(this.slot, stack);
        }
    }

    @Nullable
    private ItemStack getRandomItemFromLootTable(LivingEntity living) {
        WeightedResourceLocation randomLootTable = this.getRandomLootTable(living);
        if (randomLootTable == null) {
            return null;
        }
        MinecraftServer server = living.m_20194_();
        if (server == null) {
            return null;
        }
        LootParams.Builder lootparams$builder = new LootParams.Builder((ServerLevel)living.m_9236_()).m_287286_(LootContextParams.f_81457_, (Object)living.m_269291_().m_269425_()).m_287286_(LootContextParams.f_81455_, (Object)living).m_287286_(LootContextParams.f_81460_, (Object)living.m_20182_());
        LootTable lootTable = server.m_278653_().m_278676_(randomLootTable.getLocation());
        ObjectArrayList randomItems = lootTable.m_287195_(lootparams$builder.m_287235_(LootContextParamSets.f_81415_));
        if (randomItems.isEmpty()) {
            return null;
        }
        return (ItemStack)randomItems.stream().findFirst().get();
    }

    private List<MPRItem> getItems(LivingEntity entity) {
        ArrayList<MPRItem> finalItems = new ArrayList<MPRItem>();
        for (MPRItem item : this.items) {
            MPRItem mprItem = item.computeAndGet(entity);
            if (mprItem == null) continue;
            finalItems.add(mprItem);
        }
        return finalItems;
    }

    private List<WeightedResourceLocation> getLootTables(LivingEntity entity) {
        ArrayList<WeightedResourceLocation> finalLootTables = new ArrayList<WeightedResourceLocation>();
        for (WeightedResourceLocation weightedResourceLocation : this.lootTables) {
            WeightedResourceLocation weightedResourceLocation2 = weightedResourceLocation.computeAndGet(entity);
            if (weightedResourceLocation2 == null) continue;
            finalLootTables.add(weightedResourceLocation2);
        }
        return finalLootTables;
    }

    @Nullable
    public MPRItem getRandomItem(LivingEntity entity) {
        List<MPRItem> items = this.getItems(entity);
        if (items.isEmpty()) {
            return null;
        }
        return (MPRItem)WeightedRandom.getRandomItem((RandomSource)entity.m_9236_().f_46441_, items);
    }

    @Nullable
    public WeightedResourceLocation getRandomLootTable(LivingEntity entity) {
        List<WeightedResourceLocation> lootTables = this.getLootTables(entity);
        if (lootTables.isEmpty()) {
            return null;
        }
        return (WeightedResourceLocation)WeightedRandom.getRandomItem((RandomSource)entity.m_9236_().f_46441_, lootTables);
    }

    public static class Serializer
    implements JsonDeserializer<MPREquipmentProperty>,
    JsonSerializer<MPREquipmentProperty> {
        public MPREquipmentProperty deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jObject = json.getAsJsonObject();
            return new MPREquipmentProperty((EquipmentSlot)GsonHelper.m_13836_((JsonObject)jObject, (String)"slot", (JsonDeserializationContext)context, EquipmentSlot.class), SerializerUtils.deserializeList(jObject, "items", context, MPRItem.class, false), SerializerUtils.deserializeList(jObject, "loot_tables", context, WeightedLootTable.class, false), MPRItemFunction.deserializeList(jObject, "functions", context), MPRCondition.deserializeConditions(jObject, context));
        }

        public JsonElement serialize(MPREquipmentProperty src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jObject = context.serialize(src.functions).getAsJsonObject();
            jObject.add("slot", context.serialize((Object)src.slot));
            jObject.add("items", (JsonElement)SerializerUtils.serializeList(src.items, context));
            jObject.add("loot_tables", (JsonElement)SerializerUtils.serializeList(src.lootTables, context));
            return src.endSerialization(jObject, context);
        }
    }
}

