/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.mobspropertiesrandomness.data.json.condition;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import insane96mcp.mobspropertiesrandomness.data.json.condition.MPRCondition;
import insane96mcp.mobspropertiesrandomness.data.json.util.PlayerMode;
import insane96mcp.mobspropertiesrandomness.util.SerializerUtils;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.darkhax.gamestages.GameStageHelper;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

@JsonAdapter(value=Serializer.class)
public class MPRGameStageCondition
extends MPRCondition {
    public List<String> gameStages;
    public PlayerMode player;

    public MPRGameStageCondition(List<String> gameStages, PlayerMode player, boolean inverted) {
        super(inverted);
        this.gameStages = gameStages;
        this.player = player;
    }

    @Override
    protected boolean conditionCheck(LivingEntity living) {
        List<ServerPlayer> players = new ArrayList();
        if (this.player == PlayerMode.NEAREST) {
            ServerPlayer nearestPlayer = (ServerPlayer)living.m_9236_().m_45930_((Entity)living, 128.0);
            if (nearestPlayer == null) {
                return false;
            }
            players.add(nearestPlayer);
        } else {
            players = living.m_9236_().m_45976_(ServerPlayer.class, living.m_20191_().m_82400_(128.0));
            if (players.isEmpty()) {
                return false;
            }
        }
        for (ServerPlayer player : players) {
            if (!GameStageHelper.hasAllOf((Player)player, this.gameStages)) continue;
            return true;
        }
        return false;
    }

    public static class Serializer
    implements JsonDeserializer<MPRGameStageCondition>,
    JsonSerializer<MPRGameStageCondition> {
        public MPRGameStageCondition deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jObject = json.getAsJsonObject();
            List<String> values = SerializerUtils.deserializeList(jObject, "game_stages", context, String.class);
            if (values.isEmpty()) {
                throw new JsonParseException("No game_stages specified for Game Stage Condition");
            }
            PlayerMode playerMode = PlayerMode.NEAREST;
            if (jObject.has("player")) {
                playerMode = (PlayerMode)((Object)context.deserialize(jObject.get("player"), PlayerMode.class));
            }
            return new MPRGameStageCondition(values, playerMode, MPRCondition.deserializeInverted(jObject));
        }

        public JsonElement serialize(MPRGameStageCondition src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jObject = new JsonObject();
            jObject.add("game_stages", context.serialize(src.gameStages));
            jObject.add("player", context.serialize((Object)src.player));
            return src.endSerialization(jObject);
        }
    }
}

