/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.mobspropertiesrandomness.data.json.property;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import insane96mcp.mobspropertiesrandomness.MPR;
import insane96mcp.mobspropertiesrandomness.data.json.condition.MPRCondition;
import insane96mcp.mobspropertiesrandomness.data.json.condition.MPRConditionable;
import insane96mcp.mobspropertiesrandomness.data.json.property.PropertiesRegistry;
import insane96mcp.mobspropertiesrandomness.util.Logger;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

@JsonAdapter(value=Serializer.class)
public class MPRProperty
extends MPRConditionable {
    public MPRProperty(List<MPRCondition> conditions) {
        super(conditions);
    }

    public boolean tryApply(LivingEntity livingEntity) {
        if (!MPRCondition.conditionsApply(this.conditions, livingEntity)) {
            return false;
        }
        return this.apply(livingEntity);
    }

    public boolean apply(LivingEntity living) {
        throw new UnsupportedOperationException("apply(LivingEntity) not implemented");
    }

    @Nullable
    public static MPRProperty deserialize(JsonElement element, JsonDeserializationContext context) {
        JsonObject jObjectProperty = element.getAsJsonObject();
        ResourceLocation propertyId = MPR.locationFrom(GsonHelper.m_13906_((JsonObject)jObjectProperty, (String)"property"));
        Class<? extends MPRProperty> propertyType = PropertiesRegistry.get(propertyId);
        if (propertyType == null) {
            Logger.warn("property %s does not exist. Skipping".formatted(propertyId), new Object[0]);
            return null;
        }
        return (MPRProperty)context.deserialize((JsonElement)jObjectProperty, propertyType);
    }

    public static List<MPRProperty> deserializeList(JsonObject jObject, String memberName, JsonDeserializationContext context) {
        ArrayList<MPRProperty> properties = new ArrayList<MPRProperty>();
        if (!jObject.has(memberName)) {
            return properties;
        }
        JsonArray aProperties = GsonHelper.m_13933_((JsonObject)jObject, (String)memberName);
        for (JsonElement jsonElement : aProperties) {
            MPRProperty property = MPRProperty.deserialize(jsonElement, context);
            if (property == null) continue;
            properties.add(property);
        }
        return properties;
    }

    public static class Serializer
    implements JsonDeserializer<MPRProperty>,
    JsonSerializer<MPRProperty> {
        public MPRProperty deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return new MPRProperty(MPRCondition.deserializeList(json.getAsJsonObject(), "conditions", context));
        }

        public JsonElement serialize(MPRProperty src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jObject = new JsonObject();
            return src.endSerialization(jObject, context);
        }
    }
}

