/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.mobspropertiesrandomness.data.json.property.preset;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import insane96mcp.insanelib.util.weightedrandom.IWeightedRandom;
import insane96mcp.mobspropertiesrandomness.data.MPRPresetReloadListener;
import insane96mcp.mobspropertiesrandomness.data.json.MPRProperties;
import insane96mcp.mobspropertiesrandomness.data.json.condition.MPRCondition;
import insane96mcp.mobspropertiesrandomness.data.json.condition.MPRConditionable;
import insane96mcp.mobspropertiesrandomness.data.json.util.modifiable.MPRModifiableValue;
import insane96mcp.mobspropertiesrandomness.util.Logger;
import java.lang.reflect.Type;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.LivingEntity;

@JsonAdapter(value=Serializer.class)
public class MPRWeightedPreset
extends MPRConditionable
implements IWeightedRandom {
    private final ResourceLocation presetId;
    @Nullable
    public MPRProperties properties = null;
    private final MPRModifiableValue modifiableWeight;
    private int _weight;
    private boolean valid = true;

    public MPRWeightedPreset(ResourceLocation presetId, MPRModifiableValue modifiableWeight, List<MPRCondition> conditions) {
        super(conditions);
        this.presetId = presetId;
        this.modifiableWeight = modifiableWeight;
    }

    @Nullable
    public MPRWeightedPreset computeAndGet(LivingEntity entity) {
        if (!this.valid || !MPRCondition.conditionsApply(this.conditions, entity)) {
            return null;
        }
        this._weight = (int)this.modifiableWeight.getValue(entity);
        if (this._weight <= 0) {
            return null;
        }
        return this;
    }

    public int getWeight() {
        return this._weight;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void resolve() {
        this.properties = MPRPresetReloadListener.PRESETS.get(this.presetId);
        if (this.properties == null) {
            Logger.warn("Preset %s does not exist. Ignoring", this.presetId);
            this.valid = false;
        }
    }

    public static class Serializer
    implements JsonSerializer<MPRWeightedPreset>,
    JsonDeserializer<MPRWeightedPreset> {
        public MPRWeightedPreset deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jObject = json.getAsJsonObject();
            String sPreset = GsonHelper.m_13906_((JsonObject)jObject, (String)"preset");
            ResourceLocation presetId = ResourceLocation.parse((String)sPreset);
            MPRProperties preset = MPRPresetReloadListener.PRESETS.get(presetId);
            return new MPRWeightedPreset(presetId, (MPRModifiableValue)GsonHelper.m_13845_((JsonObject)jObject, (String)"weight", (Object)MPRModifiableValue.ONE, (JsonDeserializationContext)context, MPRModifiableValue.class), MPRCondition.deserializeConditions(jObject, context));
        }

        public JsonElement serialize(MPRWeightedPreset src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jObject = new JsonObject();
            jObject.addProperty("preset", src.presetId.toString());
            jObject.add("weight", context.serialize((Object)src.modifiableWeight));
            return src.endSerialization(jObject, context);
        }
    }
}

