/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.mobspropertiesrandomness.data.json.util.modifiable;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import insane96mcp.mobspropertiesrandomness.MPR;
import insane96mcp.mobspropertiesrandomness.data.json.condition.MPRCondition;
import insane96mcp.mobspropertiesrandomness.data.json.condition.MPRConditionable;
import insane96mcp.mobspropertiesrandomness.data.json.util.modifiable.ModifiersRegistry;
import insane96mcp.mobspropertiesrandomness.util.Logger;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.LivingEntity;

public abstract class MPRModifier
extends MPRConditionable {
    protected Operation operation;

    public MPRModifier(Operation operation, List<MPRCondition> conditions) {
        super(conditions);
        this.operation = operation;
    }

    public final double tryApply(double value, LivingEntity living) {
        if (!MPRCondition.conditionsApply(this.conditions, living)) {
            return value;
        }
        return this.operation == Operation.ADD ? value + this.getModifier(living) : value * this.getModifier(living);
    }

    protected abstract double getModifier(LivingEntity var1);

    protected double getNoModifier() {
        return this.operation == Operation.ADD ? 0.0 : 1.0;
    }

    public static Operation deserializeOperation(JsonObject json, JsonDeserializationContext context) {
        return (Operation)((Object)GsonHelper.m_13836_((JsonObject)json, (String)"operation", (JsonDeserializationContext)context, Operation.class));
    }

    @Override
    public JsonObject endSerialization(JsonObject jObject, JsonSerializationContext context) {
        jObject.add("operation", context.serialize((Object)this.operation));
        return super.endSerialization(jObject, context);
    }

    public static List<MPRModifier> deserializeList(JsonObject jObject, String memberName, JsonDeserializationContext context) {
        ArrayList<MPRModifier> modifiers = new ArrayList<MPRModifier>();
        if (!jObject.has(memberName)) {
            return modifiers;
        }
        JsonArray aModifiers = GsonHelper.m_13933_((JsonObject)jObject, (String)memberName);
        for (JsonElement jsonElement : aModifiers) {
            JsonObject jObjectCondition = jsonElement.getAsJsonObject();
            ResourceLocation modifierId = MPR.locationFrom(GsonHelper.m_13906_((JsonObject)jObjectCondition, (String)"modifier"));
            Class<? extends MPRModifier> modifierType = ModifiersRegistry.get(modifierId);
            if (modifierType == null) {
                Logger.warn("modifier %s does not exist. Skipping".formatted(modifierId), new Object[0]);
                continue;
            }
            modifiers.add((MPRModifier)context.deserialize((JsonElement)jObjectCondition, modifierType));
        }
        return modifiers;
    }

    public static enum Operation {
        ADD,
        MULTIPLY;

    }
}

