/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.mobspropertiesrandomness.data;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import insane96mcp.mobspropertiesrandomness.MPR;
import insane96mcp.mobspropertiesrandomness.data.json.MPRMob;
import insane96mcp.mobspropertiesrandomness.data.json.property.preset.MPRPresetsProperty;
import insane96mcp.mobspropertiesrandomness.data.json.property.preset.MPRWeightedPreset;
import insane96mcp.mobspropertiesrandomness.util.Logger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;

public class MPRMobReloadListener
extends SimplePreparableReloadListener<Map<ResourceLocation, JsonElement>> {
    public static List<MPRMob> MPR_MOBS = new ArrayList<MPRMob>();
    public static final MPRMobReloadListener INSTANCE;
    private static final Gson GSON;
    private final String directory;

    public MPRMobReloadListener() {
        this.directory = "mobs_properties_randomness/mobs";
    }

    @NotNull
    protected Map<ResourceLocation, JsonElement> prepare(@NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
        HashMap<ResourceLocation, JsonElement> map = new HashMap<ResourceLocation, JsonElement>();
        MPRMobReloadListener.scanDirectory(resourceManager, this.directory, GSON, map);
        return map;
    }

    public static void scanDirectory(ResourceManager resourceManager, String directory, Gson gson, Map<ResourceLocation, JsonElement> map) {
        FileToIdConverter filetoidconverter = FileToIdConverter.m_246568_((String)directory);
        for (Map.Entry entry : filetoidconverter.m_247457_(resourceManager).entrySet()) {
            ResourceLocation key = (ResourceLocation)entry.getKey();
            ResourceLocation id = filetoidconverter.m_245273_(key);
            try {
                BufferedReader reader = ((Resource)entry.getValue()).m_215508_();
                try {
                    JsonElement jsonElement = (JsonElement)GsonHelper.m_13776_((Gson)gson, (Reader)reader, JsonElement.class);
                    JsonElement duplicated = map.put(id, jsonElement);
                    if (duplicated == null) continue;
                    throw new IllegalStateException("Duplicate data file ignored with ID " + String.valueOf(id));
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException exception) {
                Logger.error("Error loading Mob %s: %s", key, exception.getMessage());
            }
        }
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> map, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
        MPR_MOBS.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
            try {
                ResourceLocation name = entry.getKey();
                Logger.info("Loading Mob %s", entry.getKey());
                String[] split = name.m_135815_().split("/");
                if (split[split.length - 1].startsWith("_")) continue;
                MPRMob mob2 = (MPRMob)GSON.fromJson(entry.getValue(), MPRMob.class);
                MPR_MOBS.add(mob2);
                Logger.info("Loaded Mob %s", entry.getKey());
            }
            catch (Exception e) {
                StringBuilder sb = new StringBuilder("Failed loading Mob " + String.valueOf(entry.getKey()) + ": " + e.getMessage());
                for (StackTraceElement s : e.getStackTrace()) {
                    sb.append("\n").append(s.toString());
                }
                Logger.error(sb.toString(), new Object[0]);
            }
        }
        MPR_MOBS.forEach(mob -> mob.getProperties().forEach(property -> {
            if (property instanceof MPRPresetsProperty) {
                MPRPresetsProperty mprPresetsProperty = (MPRPresetsProperty)property;
                mprPresetsProperty.weightedPresets.forEach(MPRWeightedPreset::resolve);
            }
        }));
        MPR_MOBS.sort(Comparator.comparing(mob -> mob.priority, Comparator.reverseOrder()));
        Logger.info("Loaded %s Mob(s)", MPR_MOBS.size());
    }

    static {
        GSON = MPR.createGson();
        INSTANCE = new MPRMobReloadListener();
    }
}

