/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.mobspropertiesrandomness.data.json.condition;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import insane96mcp.mobspropertiesrandomness.MPR;
import insane96mcp.mobspropertiesrandomness.data.json.condition.ConditionsRegistry;
import insane96mcp.mobspropertiesrandomness.util.Logger;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.LivingEntity;

public abstract class MPRCondition {
    public boolean inverted;

    public MPRCondition(boolean inverted) {
        this.inverted = inverted;
    }

    public final boolean conditionApplies(LivingEntity livingEntity) {
        return this.tryInvert(this.conditionCheck(livingEntity));
    }

    protected abstract boolean conditionCheck(LivingEntity var1);

    public final boolean tryInvert(boolean value) {
        return this.inverted ? !value : value;
    }

    public static boolean deserializeInverted(JsonObject jObject) {
        return jObject.has("inverted") && jObject.get("inverted").getAsBoolean();
    }

    public JsonObject endSerialization(JsonObject jObject) {
        jObject.addProperty("condition", ConditionsRegistry.get(this.getClass()).toString());
        if (this.inverted) {
            jObject.addProperty("inverted", Boolean.valueOf(true));
        }
        return jObject;
    }

    public static List<MPRCondition> deserializeConditions(JsonObject jObject, JsonDeserializationContext context) {
        return MPRCondition.deserializeList(jObject, "conditions", context);
    }

    public static List<MPRCondition> deserializeList(JsonObject jObject, String memberName, JsonDeserializationContext context) {
        ArrayList<MPRCondition> conditions = new ArrayList<MPRCondition>();
        if (!jObject.has(memberName)) {
            return conditions;
        }
        JsonArray aConditions = GsonHelper.m_13933_((JsonObject)jObject, (String)memberName);
        return MPRCondition.deserializeList(aConditions, context);
    }

    public static List<MPRCondition> deserializeList(JsonArray aConditions, JsonDeserializationContext context) {
        ArrayList<MPRCondition> conditions = new ArrayList<MPRCondition>();
        for (JsonElement jsonElement : aConditions) {
            JsonObject jObjectCondition = jsonElement.getAsJsonObject();
            ResourceLocation conditionId = MPR.locationFrom(GsonHelper.m_13906_((JsonObject)jObjectCondition, (String)"condition"));
            Class<? extends MPRCondition> conditionType = ConditionsRegistry.get(conditionId);
            if (conditionType == null) {
                Logger.warn("condition %s does not exist. Skipping".formatted(conditionId), new Object[0]);
                continue;
            }
            conditions.add((MPRCondition)context.deserialize((JsonElement)jObjectCondition, conditionType));
        }
        return conditions;
    }

    public static boolean conditionsApply(List<MPRCondition> conditions, LivingEntity entity) {
        for (MPRCondition condition : conditions) {
            if (condition.conditionApplies(entity)) continue;
            return false;
        }
        return true;
    }
}

