/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.mobspropertiesrandomness.data.json.property;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import insane96mcp.insanelib.util.ModNBTData;
import insane96mcp.mobspropertiesrandomness.MPR;
import insane96mcp.mobspropertiesrandomness.data.json.condition.MPRCondition;
import insane96mcp.mobspropertiesrandomness.data.json.property.MPRProperty;
import insane96mcp.mobspropertiesrandomness.util.SerializerUtils;
import java.lang.reflect.Type;
import java.util.List;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.registries.ForgeRegistries;

@JsonAdapter(value=Serializer.class)
public class MPREffectImmunityProperty
extends MPRProperty {
    private static final ResourceLocation EFFECT_IMMUNITY = MPR.location("effect_immunity");
    public List<ResourceLocation> mobEffects;

    public MPREffectImmunityProperty(List<ResourceLocation> mobEffects, List<MPRCondition> conditions) {
        super(conditions);
        this.mobEffects = mobEffects;
    }

    @Override
    public boolean apply(LivingEntity living) {
        ListTag listTag = new ListTag();
        for (ResourceLocation mobEffect : this.mobEffects) {
            listTag.add((Object)StringTag.m_129297_((String)mobEffect.toString()));
        }
        ModNBTData.put((Entity)living, (ResourceLocation)EFFECT_IMMUNITY, (Object)listTag);
        return true;
    }

    public static boolean shouldPreventEffect(LivingEntity living, MobEffect effect) {
        if (living.m_9236_().f_46443_ || !ModNBTData.contains((Entity)living, (ResourceLocation)EFFECT_IMMUNITY)) {
            return false;
        }
        ListTag listTag = ModNBTData.getList((Entity)living, (ResourceLocation)EFFECT_IMMUNITY, (int)8);
        for (int i = 0; i < listTag.size(); ++i) {
            String s = listTag.m_128778_(i);
            if (!ForgeRegistries.MOB_EFFECTS.getKey((Object)effect).toString().equals(s)) continue;
            return true;
        }
        return false;
    }

    public static class Serializer
    implements JsonDeserializer<MPREffectImmunityProperty>,
    JsonSerializer<MPREffectImmunityProperty> {
        public MPREffectImmunityProperty deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jObject = json.getAsJsonObject();
            return new MPREffectImmunityProperty(SerializerUtils.deserializeLocationList(jObject, "effects", context), MPRCondition.deserializeConditions(jObject, context));
        }

        public JsonElement serialize(MPREffectImmunityProperty src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jObject = new JsonObject();
            SerializerUtils.serializeLocationList(jObject, "effects", context, src.mobEffects);
            return src.endSerialization(jObject, context);
        }
    }
}

