/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.mobspropertiesrandomness.data.json.property;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import insane96mcp.mobspropertiesrandomness.data.json.condition.MPRCondition;
import insane96mcp.mobspropertiesrandomness.data.json.property.MPRProperty;
import insane96mcp.mobspropertiesrandomness.data.json.util.modifiable.MPRModifiableValue;
import insane96mcp.mobspropertiesrandomness.data.json.util.modifiable.MPRRange;
import insane96mcp.mobspropertiesrandomness.util.Logger;
import insane96mcp.mobspropertiesrandomness.util.SerializerUtils;
import java.lang.reflect.Type;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;

@JsonAdapter(value=Serializer.class)
public class MPRPotionEffectProperty
extends MPRProperty {
    public MobEffect mobEffect;
    public Stackable amplifier;
    public Stackable duration;
    public boolean ambient;
    public boolean hideParticles;

    public MPRPotionEffectProperty(MobEffect mobEffect, Stackable amplifier, Stackable duration, boolean ambient, boolean hideParticles, List<MPRCondition> conditions) {
        super(conditions);
        this.mobEffect = mobEffect;
        this.amplifier = amplifier;
        this.duration = duration;
        this.ambient = ambient;
        this.hideParticles = hideParticles;
    }

    @Override
    public boolean apply(LivingEntity living) {
        double duration;
        if (this.mobEffect == null) {
            return false;
        }
        int currentDuration = 0;
        int currentLevel = 0;
        if (living.m_21124_(this.mobEffect) != null) {
            currentDuration = living.m_21124_(this.mobEffect).m_19557_();
            currentLevel = living.m_21124_(this.mobEffect).m_19564_() + 1;
        }
        MobEffectInstance effectInstance = new MobEffectInstance(this.mobEffect, (int)((duration = this.duration.getStackedValue(living, currentDuration)) == -1.0 ? -1.0 : duration * 20.0), this.amplifier.getStackedIntValue(living, currentLevel) - 1, this.ambient, !this.hideParticles, false);
        living.m_7292_(effectInstance);
        return true;
    }

    @JsonAdapter(value=Serializer.class)
    public static class Stackable {
        public static final Stackable ZERO = new Stackable(MPRRange.ZERO);
        public static final Stackable ONE = new Stackable(MPRRange.ONE);
        public MPRRange value;
        public boolean stack;
        public MPRRange cap;

        public Stackable(MPRRange value) {
            this(value, false, MPRRange.UNLIMITED);
        }

        public Stackable(MPRRange value, boolean stack, MPRRange cap) {
            this.value = value;
            this.stack = stack;
            this.cap = cap;
        }

        public double getStackedValue(LivingEntity living, double originalValue) {
            double value = this.value.getDoubleBetween(living);
            if (!this.stack) {
                return value;
            }
            if (this.cap != MPRRange.UNLIMITED) {
                return Mth.m_14008_((double)value, (double)this.cap.getMin(living), (double)this.cap.getMax(living));
            }
            return value + originalValue;
        }

        public int getStackedIntValue(LivingEntity living, int originalValue) {
            int value = this.value.getIntBetween(living);
            if (!this.stack) {
                return value;
            }
            if (this.cap != MPRRange.UNLIMITED) {
                return Mth.m_14045_((int)value, (int)((int)this.cap.getMin(living)), (int)((int)this.cap.getMax(living)));
            }
            return value + originalValue;
        }

        public static class Serializer
        implements JsonDeserializer<Stackable>,
        JsonSerializer<Stackable> {
            public Stackable deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonObject jObject = json.getAsJsonObject();
                if (jObject.isJsonPrimitive()) {
                    return new Stackable(new MPRRange(jObject.getAsDouble()));
                }
                MPRRange value = (MPRRange)GsonHelper.m_13836_((JsonObject)jObject, (String)"value", (JsonDeserializationContext)context, MPRRange.class);
                boolean stack = GsonHelper.m_13855_((JsonObject)jObject, (String)"stack", (boolean)false);
                MPRRange cap = (MPRRange)GsonHelper.m_13845_((JsonObject)jObject, (String)"cap", (Object)MPRRange.UNLIMITED, (JsonDeserializationContext)context, MPRRange.class);
                return new Stackable(value, stack, cap);
            }

            public JsonElement serialize(Stackable src, Type typeOfSrc, JsonSerializationContext context) {
                if (!src.stack && src.cap == MPRRange.UNLIMITED && src.value.min == src.value.max) {
                    return new JsonPrimitive((Number)src.value.min.value);
                }
                JsonObject jObject = new JsonObject();
                jObject.add("value", context.serialize((Object)src.value));
                if (src.stack) {
                    jObject.addProperty("stack", Boolean.valueOf(true));
                }
                if (src.cap != MPRRange.UNLIMITED) {
                    jObject.add("cap", context.serialize((Object)src.cap));
                }
                return jObject;
            }
        }
    }

    public static class Serializer
    implements JsonDeserializer<MPRPotionEffectProperty>,
    JsonSerializer<MPRPotionEffectProperty> {
        public MPRPotionEffectProperty deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jObject = json.getAsJsonObject();
            MobEffect mobEffect = (MobEffect)SerializerUtils.deserializeRegistryObject(jObject, "effect", Registries.f_256929_);
            if (mobEffect == null) {
                Logger.warn("Invalid effect: %s. Will be ignored.", jObject.get("effect").getAsString());
            }
            Stackable amplifier = jObject.has("amplifier") ? (Stackable)context.deserialize(jObject.get("amplifier"), Stackable.class) : Stackable.ONE;
            Stackable duration = (Stackable)GsonHelper.m_13845_((JsonObject)jObject, (String)"duration", (Object)new Stackable(new MPRRange(new MPRModifiableValue(-1.0))), (JsonDeserializationContext)context, Stackable.class);
            boolean ambient = GsonHelper.m_13855_((JsonObject)jObject, (String)"ambient", (boolean)false);
            boolean hideParticles = GsonHelper.m_13855_((JsonObject)jObject, (String)"hide_particles", (boolean)false);
            if (ambient && hideParticles) {
                Logger.warn("Particles are hidden, but ambient is enabled for %s. Ambient doesn't work if particles are hidden.".formatted(mobEffect), new Object[0]);
            }
            return new MPRPotionEffectProperty(mobEffect, amplifier, duration, ambient, hideParticles, MPRCondition.deserializeConditions(jObject, context));
        }

        public JsonElement serialize(MPRPotionEffectProperty src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jObject = new JsonObject();
            jObject.add("effect", SerializerUtils.serializeRegistryObject(src.mobEffect, Registries.f_256929_));
            jObject.add("amplifier", context.serialize((Object)src.amplifier));
            jObject.add("duration", context.serialize((Object)src.duration));
            jObject.addProperty("ambient", Boolean.valueOf(src.ambient));
            jObject.addProperty("hide_particles", Boolean.valueOf(src.hideParticles));
            return src.endSerialization(jObject, context);
        }
    }
}

