/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.mobspropertiesrandomness.data.json.property.equipment;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import insane96mcp.mobspropertiesrandomness.MPR;
import insane96mcp.mobspropertiesrandomness.data.json.condition.MPRCondition;
import insane96mcp.mobspropertiesrandomness.data.json.condition.MPRConditionable;
import insane96mcp.mobspropertiesrandomness.data.json.property.equipment.ItemFunctionsRegistry;
import insane96mcp.mobspropertiesrandomness.util.Logger;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public abstract class MPRItemFunction
extends MPRConditionable {
    public MPRItemFunction(List<MPRCondition> conditions) {
        super(conditions);
    }

    public final boolean tryApply(LivingEntity livingEntity, ItemStack stack, EquipmentSlot slot) {
        if (!MPRCondition.conditionsApply(this.conditions, livingEntity)) {
            return false;
        }
        return this.apply(livingEntity, stack, slot);
    }

    protected abstract boolean apply(LivingEntity var1, ItemStack var2, EquipmentSlot var3);

    public static List<MPRItemFunction> deserializeList(JsonObject jObject, String memberName, JsonDeserializationContext context) {
        ArrayList<MPRItemFunction> itemFunctions = new ArrayList<MPRItemFunction>();
        if (!jObject.has(memberName)) {
            return itemFunctions;
        }
        JsonArray aFunctions = GsonHelper.m_13933_((JsonObject)jObject, (String)memberName);
        for (JsonElement jsonElement : aFunctions) {
            JsonObject jObjectItemFunction = jsonElement.getAsJsonObject();
            ResourceLocation itemFunctionId = MPR.locationFrom(GsonHelper.m_13906_((JsonObject)jObjectItemFunction, (String)"function"));
            Class<? extends MPRItemFunction> itemFunctionType = ItemFunctionsRegistry.get(itemFunctionId);
            if (itemFunctionType == null) {
                Logger.warn("item function %s does not exist. Skipping".formatted(itemFunctionId), new Object[0]);
                continue;
            }
            itemFunctions.add((MPRItemFunction)context.deserialize((JsonElement)jObjectItemFunction, itemFunctionType));
        }
        return itemFunctions;
    }
}

